/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**********************************/
/* ballerspiel-editorfunktionen   */
/* (C) April 1996 by Michael Haar */
/**********************************/

/* nderungen: */

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include "DEFS.H"
#include "FUNCS.H"
#include "VARS.H"

/* globale Variablen */
int edit_kette, edit_kurve;
int scroll;
KETTENSTART paste;

/* Funtkionsprototypen */
void init_editor(void);
void editor_tasten(void);
void show_starts(void);
void zeige_kette(void);
void editor_info(void);
void save_level(int level);
BOOLEAN load_level(int level);
void show_ketten(void);

int bildnummereingabe(int x, int y, int nr);
int extraeingabe(int x, int y, int nr);
void zeichne_bahn(OBJEKT *obj, int start_x, BOOLEAN fliegen, int color) ;

/* tolle funktionen von Ulrich */
void show_ketten(void)
{
	int i;
	int z;
	z = 900;
	if(edit_kurve == -1)
		edit_kette = -1;
	for(i = 0; i < ANZ_LEVELKETTEN; i++)
		if(startkette[i].start_x)
		{
			if((game_scrollpos + 400 >	startkette[i].start_x ) && (game_scrollpos - 700 <	startkette[i].start_x ))
			{
				zeichne_bahn(&startkette[i].obj, startkette[i].start_x - game_scrollpos, FALSE, 31);
				if (( startkette[i].start_x - game_scrollpos > 0) && (edit_kurve == -1))
				{
					if (startkette[i].start_x  - game_scrollpos < z)
					{
						edit_kette = i;
						z = startkette[i].start_x - game_scrollpos;
					}
				}
			}
		}
}

/* Funktionen */
void init_editor(void)
{
	edit_kette = -1;
	edit_kurve = -1;
	scroll = 1;
}

void gegner_hilfe(void)
{
	void *alt_screen, *helpscreen;

	alt_screen = screen_addr;
	helpscreen = malloc(screen_width * screen_height);
	screen_addr = helpscreen;

	// 1. Seite
	cls(0);

	put_text(&schrift, 0, 0 * schrift.char_h, "             ENEMY - HELP - PAGE 1:");
	put_text(&schrift, 0, 1 * schrift.char_h, "ENEMY NUMBERS:");
	put_text(&schrift, 0, 2 * schrift.char_h, "0 - CLOUDS                   - PIX: 25..");
	put_text(&schrift, 0, 3 * schrift.char_h, "1 - PLATFORMS                - PIX: 30..");
	put_text(&schrift, 0, 4 * schrift.char_h, "3 - FLIP-FLYER               - PIX: 35..");
	put_text(&schrift, 0, 5 * schrift.char_h, "4 - PIXCHANGE-ANIMATED-FLYER - PIX: 35..");
	put_text(&schrift, 0, 6 * schrift.char_h, "5 - FIRING ROTATED-FLYER     - PIX: 35..");
	put_text(&schrift, 0, 7 * schrift.char_h, "6 - ROTATED CANNON           - PIX: 58..");
	put_text(&schrift, 0, 8 * schrift.char_h, "7 - PLAYERS ROCKETS          - PIX: 35..");
	put_text(&schrift, 0, 9 * schrift.char_h, "8 - ROCKETLAUNCHER           - PIX: 74..");
	put_text(&schrift, 0, 10 * schrift.char_h, "9 - ROTATED-FLYER           - PIX: 35..");
	put_text(&schrift, 0, 11 * schrift.char_h, "10 - FAST PIXCHANGE-ANI-FLYER -PIX:35..");
	put_text(&schrift, 0, 12 * schrift.char_h, "11 - LIFTING CANNON         - PIX: 110..");
	put_text(&schrift, 0, 13 * schrift.char_h, "12 - SPREAD CANNON          - PIX: 118 ..");
	put_text(&schrift, 0, 14 * schrift.char_h, "6 - TANK UP                 - PIX: 126 ..");
	put_text(&schrift, 0, 15 * schrift.char_h, "5 - VEHICLE 1               - PIX: 134 ..");
	put_text(&schrift, 0, 16 * schrift.char_h, "13 - MINE                   - PIX: 142 ..");
	put_text(&schrift, 0, 17 * schrift.char_h, "6 - TANK LEFT               - PIX: 147 ..");
	put_text(&schrift, 0, 18 * schrift.char_h, "14 - GROUND SPIKE           - PIX: 155 ..");
	put_text(&schrift, 0, 19 * schrift.char_h, "4 - BIG FLY                 - PIX: 163 ..");
	put_text(&schrift, 0, 20 * schrift.char_h, "9 - LITTLE FLY              - PIX: 167 ..");
	put_text(&schrift, 0, 21 * schrift.char_h, "3 - BIG BEETLE              - PIX: 175 ..");
	put_text(&schrift, 0, 22 * schrift.char_h, "3 - ONLYWING                - PIX: 178 ..");
	put_text(&schrift, 0, 23 * schrift.char_h, "15 - MINE LAYER             - PIX: 181 ..");
	put_text(&schrift, 0, 24 * schrift.char_h, "9 - KILRATHI                - PIX: 208 ..");

	Copy2Screen();
	while(!keyTest(KEY_SPACE) && !keyTest(KEY_ENTER) && !keyTest(KEY_ESC))
		;
	while(keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_ESC))
		;

	// 2. Seite
	cls(0);

	put_text(&schrift, 0, 0 * schrift.char_h, "             ENEMY - HELP PAGE 2:");
	put_text(&schrift, 0, 1 * schrift.char_h, "ENEMY NUMBERS:");
	put_text(&schrift, 0, 2 * schrift.char_h, "16 - SWINGING CHAIN          - PIX:");
	put_text(&schrift, 0, 3 * schrift.char_h, "17 - PLAYERSEARCHING FLAMES  - PIX:");
	put_text(&schrift, 0, 4 * schrift.char_h, "18 - SUBMARINES              - PIX:");
	put_text(&schrift, 0, 5 * schrift.char_h, "19 - ROCKETS/PLAYERSEARCH    - PIX:");
	put_text(&schrift, 0, 6 * schrift.char_h, "20 - DRIVING/STANDFIRECIRCLE - PIX:");
	put_text(&schrift, 0, 7 * schrift.char_h, "21 - FORWARDFIRING SHIPS     - PIX:");
	put_text(&schrift, 0, 8 * schrift.char_h, "22 - ANISHIPS/STANDFIRE      - PIX:");
	put_text(&schrift, 0, 9 * schrift.char_h, "23 - FLIPFLYER/STANDFIRE     - PIX:");
	put_text(&schrift, 0, 10 * schrift.char_h, "24 - ROTATEFLYER/STANDFIRE   - PIX:");
	put_text(&schrift, 0, 11 * schrift.char_h, "25 - BACKFIRING SHOOTER      - PIX:");
	put_text(&schrift, 0, 12 * schrift.char_h, "26 - PLAYERSEARCHING         - PIX:");
	put_text(&schrift, 0, 13 * schrift.char_h, "27 - ANI/FIRING AT PLAYER    - PIX:");
	put_text(&schrift, 0, 14 * schrift.char_h, "28 - SUBMARINES WITH TORPS   - PIX:");
	put_text(&schrift, 0, 15 * schrift.char_h, "29 - ANTI-MAGNET             - PIX:");
	put_text(&schrift, 0, 16 * schrift.char_h, "30 - EXPLODESHOOTING MINE    - PIX:");
	put_text(&schrift, 0, 17 * schrift.char_h, "31 - (MINI-)LAUNCHING FLYER  - PIX:");
	put_text(&schrift, 0, 18 * schrift.char_h, "32 - SLOWSHOT-FIRESTATION    - PIX:");
	put_text(&schrift, 0, 19 * schrift.char_h, "33 - (30-)LAUNCHING FLYER    - PIX:");
	put_text(&schrift, 0, 20 * schrift.char_h, "34 - DOUBLECANNON            - PIX:");
	put_text(&schrift, 0, 21 * schrift.char_h, "35 - FLAMETHROWER            - PIX:");
	put_text(&schrift, 0, 22 * schrift.char_h, "36 - ROTATING PLATES         - PIX:");
	put_text(&schrift, 0, 23 * schrift.char_h, "37 - MINILAUNCHER            - PIX:");
	put_text(&schrift, 0, 24 * schrift.char_h, "39 - MAGNET                  - PIX:");

	Copy2Screen();
	while(!keyTest(KEY_SPACE) && !keyTest(KEY_ENTER) && !keyTest(KEY_ESC))
		;
	while(keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_ESC))
		;

	free(helpscreen);
	screen_addr = alt_screen;
	Copy2Screen();
}

/* Zahl einlesen - mit Hilfefunktion */
int get_zahl(int x, int y, int normal)
{
	strcpy(txt, "");
	while(!keyTest(KEY_ENTER))
	{
		if(keyTest(KEY_F1))
		{
			gegner_hilfe();
			delay(150);
		}
		else if(keyTest(KEY_MINUS))
		{
			strcat(txt, "-");
			delay(150);
		}
		else if(keyTest(KEY_1))
		{
			strcat(txt, "1");
			delay(150);
		}
		else if(keyTest(KEY_2))
		{
			strcat(txt, "2");
			delay(150);
		}
		else if(keyTest(KEY_3))
		{
			strcat(txt, "3");
			delay(150);
		}
		else if(keyTest(KEY_4))
		{
			strcat(txt, "4");
			delay(150);
		}
		else if(keyTest(KEY_5))
		{
			strcat(txt, "5");
			delay(150);
		}
		else if(keyTest(KEY_6))
		{
			strcat(txt, "6");
			delay(150);
		}
		else if(keyTest(KEY_7))
		{
			strcat(txt, "7");
			delay(150);
		}
		else if(keyTest(KEY_8))
		{
			strcat(txt, "8");
			delay(150);
		}
		else if(keyTest(KEY_9))
		{
			strcat(txt, "9");
			delay(150);
		}
		else if(keyTest(KEY_0))
		{
			strcat(txt, "0");
			delay(150);
		}
		else if(keyTest(KEY_BACKSPACE) && (strlen(txt) > 0))
		{
			txt[strlen(txt) - 1] = 0;
			delay(150);
		}
		show_text(&schrift, x, y, txt);
		show_text(&schrift, x + strlen(txt) * schrift.char_w, y, ">");
		Copy2Screen();
	}
	delay(150);

	if(atoi(txt) != 0)
		return(atoi(txt));
	else
		return(normal);
}

void neue_startkette(int x, unsigned char art)
{
	int i;

	i = 0;
	while((i < ANZ_LEVELKETTEN) && startkette[i].start_x)
		i++;

	if(i < ANZ_LEVELKETTEN)
	{
		startkette[i].start_x = x;
		startkette[i].obj.bahn.anz = 1;
		startkette[i].obj.bahn.akt = 0;
		startkette[i].obj.bahn.kurve[0].len = 10;
		startkette[i].obj.bahn.kurve[0].xpl = -1 * KURVENFAC * KURVENFAC;
		startkette[i].obj.bahn.kurve[0].ypl = 0;
		startkette[i].obj.bahn.kurve[0].xxpl = 0;
		startkette[i].obj.bahn.kurve[0].yypl = 0;
		startkette[i].obj.extra_listnr = -1;
		startkette[i].obj.weapon_ok = 0;

		if(art == 0)
		{
			// Standardgegner
			put_text(&schrift, 0, 10, "NEUES OBJEKT EINFUEGEN: ");
			put_text(&schrift, 0, 20, "GEGNERART: ");
			startkette[i].obj.art = get_zahl(250, 20, 4);
			put_text(&schrift, 0, 30, "ANZAHL DER OBJEKTE (MAX. 9): ");
			startkette[i].anz_objekte = get_zahl(250, 30, 5);
			put_text(&schrift, 0, 40, "KETTENABSTAND: ");
			startkette[i].obj.startpause = get_zahl(250, 40, 30);
			put_text(&schrift, 0, 50, "X-STARTPOSITION: ");
			startkette[i].obj.bahn.x = get_zahl(250, 50, 500) * KURVENFAC;
			put_text(&schrift, 0, 60, "Y-STARTPOSITION: ");
			startkette[i].obj.bahn.y = get_zahl(250, 60, 100) * KURVENFAC;
			put_text(&schrift, 0, 70, "OBJEKTBILDNUMMER: ");
			startkette[i].obj.nr = bildnummereingabe(250, 70, GEGNERPICS);
			put_text(&schrift, 0, 80, "ANIMATIONSSTUFEN: ");
			startkette[i].obj.anz_anistufen = get_zahl(250, 80, 1);
			put_text(&schrift, 0, 90, "ENERGIE: ");
			startkette[i].obj.energie = get_zahl(250, 90, 25);
			put_text(&schrift, 0, 100, "FEUERGESCHWINDIGKEIT: ");
			startkette[i].obj.weapon_fire = get_zahl(250, 100, -1);
			put_text(&schrift, 0, 110, "EXTRA: ");
			startkette[i].obj.extra = extraeingabe(250, 110, 0);
		}
		else if(art == 1)
		{
			// Wolke
			startkette[i].obj.art = 0;
			startkette[i].anz_objekte = 1;
			startkette[i].obj.startpause = 0;
			startkette[i].obj.anz_anistufen = 1;
			startkette[i].obj.energie = -1;
			startkette[i].obj.weapon_fire = -1;
			startkette[i].obj.extra = 0;

			startkette[i].obj.bahn.kurve[0].len = 120;
			startkette[i].obj.bahn.kurve[0].xpl = -4 * KURVENFAC * KURVENFAC;

			put_text(&schrift, 0, 10, "NEUE WOLKE EINFUEGEN: ");
			put_text(&schrift, 0, 20, "X-STARTPOSITION: ");
			startkette[i].obj.bahn.x = get_zahl(250, 20, 400) * KURVENFAC;
			put_text(&schrift, 0, 30, "Y-STARTPOSITION: ");
			startkette[i].obj.bahn.y = get_zahl(250, 30, 100) * KURVENFAC;
			put_text(&schrift, 0, 40, "OBJEKTBILDNUMMER: ");
			startkette[i].obj.nr = bildnummereingabe(250, 40, WOLKEPICS);
		}
		else if(art == 2)
		{
			// Plattform
			startkette[i].obj.art = 1;
			startkette[i].anz_objekte = 1;
			startkette[i].obj.startpause = 0;
			startkette[i].obj.anz_anistufen = 1;
			startkette[i].obj.energie = -1;
			startkette[i].obj.weapon_fire = -1;
			startkette[i].obj.extra = 0;

			startkette[i].obj.bahn.kurve[0].len = 400;
			startkette[i].obj.bahn.kurve[0].xpl = -1 * KURVENFAC * KURVENFAC;

			put_text(&schrift, 0, 10, "NEUE PLATTFORM EINFUEGEN: ");
			put_text(&schrift, 0, 20, "X-STARTPOSITION: ");
			startkette[i].obj.bahn.x = get_zahl(250, 20, 450) * KURVENFAC;
			put_text(&schrift, 0, 30, "Y-STARTPOSITION: ");
			startkette[i].obj.bahn.y = get_zahl(250, 30, 100) * KURVENFAC;
			put_text(&schrift, 0, 40, "OBJEKTBILDNUMMER: ");
			startkette[i].obj.nr = bildnummereingabe(250, 40, PLATTFORMPICS);
		}
		else if(art == 3)
		{
			// Geschtz
			startkette[i].obj.art = 6;
			startkette[i].anz_objekte = 1;
			startkette[i].obj.startpause = 0;
			startkette[i].obj.anz_anistufen = 0;

			startkette[i].obj.bahn.kurve[0].len = 400;
			startkette[i].obj.bahn.kurve[0].xpl = -1 * KURVENFAC * KURVENFAC;

			put_text(&schrift, 0, 10, "NEUEN GESCHUETZTURM EINFUEGEN: ");
			put_text(&schrift, 0, 20, "X-STARTPOSITION: ");
			startkette[i].obj.bahn.x = get_zahl(250, 20, 400) * KURVENFAC;
			put_text(&schrift, 0, 30, "Y-STARTPOSITION: ");
			startkette[i].obj.bahn.y = get_zahl(250, 30, 100) * KURVENFAC;
			put_text(&schrift, 0, 40, "OBJEKTBILDNUMMER: ");
			startkette[i].obj.nr = bildnummereingabe(250, 40, GEGNERPICS + 23);
			put_text(&schrift, 0, 50, "ENERGIE: ");
			startkette[i].obj.energie = get_zahl(250, 50, 50);
			put_text(&schrift, 0, 60, "FEUERGESCHWINDIGKEIT: ");
			startkette[i].obj.weapon_fire = get_zahl(250, 60, 32);
			put_text(&schrift, 0, 70, "EXTRA: ");
			startkette[i].obj.extra = extraeingabe(250, 70, 0);
		}
		else if(art == 4)
		{
			// Raketenturm
			startkette[i].obj.art = 8;
			startkette[i].anz_objekte = 1;
			startkette[i].obj.startpause = 0;
			startkette[i].obj.anz_anistufen = 0;

			startkette[i].obj.bahn.kurve[0].len = 400;
			startkette[i].obj.bahn.kurve[0].xpl = -1 * KURVENFAC * KURVENFAC;

			put_text(&schrift, 0, 10, "NEUEN RAKETENTURM EINFUEGEN: ");
			put_text(&schrift, 0, 20, "X-STARTPOSITION: ");
			startkette[i].obj.bahn.x = get_zahl(250, 20, 400) * KURVENFAC;
			put_text(&schrift, 0, 30, "Y-STARTPOSITION: ");
			startkette[i].obj.bahn.y = get_zahl(250, 30, 100) * KURVENFAC;
			put_text(&schrift, 0, 40, "OBJEKTBILDNUMMER: ");
			startkette[i].obj.nr = bildnummereingabe(250, 40, GEGNERPICS + 39);
			put_text(&schrift, 0, 50, "ENERGIE: ");
			startkette[i].obj.energie = get_zahl(250, 50, 100);
			put_text(&schrift, 0, 60, "FEUERGESCHWINDIGKEIT: ");
			startkette[i].obj.weapon_fire = get_zahl(250, 60, 64);
			put_text(&schrift, 0, 70, "EXTRA: ");
			startkette[i].obj.extra = extraeingabe(250, 70, 0);
		}
		else if(art == 5)
		{
			// Kette
			startkette[i].obj.art = 16;
			startkette[i].anz_objekte = 1;
			startkette[i].obj.startpause = 0;
			startkette[i].obj.anz_anistufen = 0;

			startkette[i].obj.bahn.kurve[0].len = 10;
			startkette[i].obj.bahn.kurve[0].xpl = -1 * KURVENFAC * KURVENFAC;

			put_text(&schrift, 0, 10, "NEUE DREHKETTE EINFUEGEN: ");
			put_text(&schrift, 0, 20, "X-STARTPOSITION: ");
			startkette[i].obj.bahn.x = get_zahl(250, 20, 400) * KURVENFAC;
			put_text(&schrift, 0, 30, "Y-STARTPOSITION: ");
			startkette[i].obj.bahn.y = get_zahl(250, 30, 100) * KURVENFAC;
			put_text(&schrift, 0, 40, "OBJEKTBILDNUMMER: ");
			startkette[i].obj.nr = bildnummereingabe(250, 40, GEGNERPICS + 190);
			put_text(&schrift, 0, 50, "ENERGIE: ");
			startkette[i].obj.energie = get_zahl(250, 50, 10000);
			put_text(&schrift, 0, 60, "DREHWINKELPLUS: ");
			startkette[i].obj.weapon_fire = get_zahl(250, 60, 1);
			put_text(&schrift, 0, 70, "EXTRA: ");
			startkette[i].obj.extra = extraeingabe(250, 70, 0);
		}

		edit_kette = i;
		edit_kurve = 0;
		if(edit_kette == anz_ketten)
			anz_ketten++;
	}
}

void kurven_ende_neue(FLUGBAHN *bahn, int *edit_kurve)
{
	int t, x, y;

	*edit_kurve = *edit_kurve + 1;
	x = bahn->x;
	y = bahn->y;
	for(t = 0; t < bahn->anz; t++)
	{
		// neusetzen
		bahn->kurve[*edit_kurve].len = bahn->kurve[t].len;
		bahn->kurve[*edit_kurve].xpl = bahn->kurve[t].xpl;
		bahn->kurve[*edit_kurve].ypl = bahn->kurve[t].ypl;
		bahn->kurve[*edit_kurve].xxpl = bahn->kurve[t].xxpl;
		bahn->kurve[*edit_kurve].yypl = bahn->kurve[t].yypl;
		// Abfahren bis Ende
		while(bahn->kurve[*edit_kurve].len)
		{
			x += bahn->kurve[*edit_kurve].xpl / KURVENFAC;
			y += bahn->kurve[*edit_kurve].ypl / KURVENFAC;
			bahn->kurve[*edit_kurve].xpl += bahn->kurve[*edit_kurve].xxpl;
			bahn->kurve[*edit_kurve].ypl += bahn->kurve[*edit_kurve].yypl;
			bahn->kurve[*edit_kurve].len--;
		}
	}
	bahn->kurve[*edit_kurve].len = 10 * KURVENFAC;
}

void edit_startkette(int such_x)
{
	int i, o, min_pos;

	o = 0;
	min_pos = 1000000;
	for(i = 0; i < ANZ_LEVELKETTEN; i++)
		if(startkette[i].start_x > such_x)
			if(startkette[i].start_x < min_pos)
			{
				min_pos = startkette[i].start_x;
				o = i;
			}

	if(min_pos < 1000000)
	{
		// startkette[o] editieren
		put_text(&schrift, 0, 10, "OBJEKT EDITIEREN: ");
		strcpy(txt, "GEGNERART (");
		itoa(startkette[o].obj.art, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 20, txt);
		startkette[o].obj.art = get_zahl(250, 20, startkette[o].obj.art);
		strcpy(txt, "ANZAHL DER OBJEKTE (");
		itoa(startkette[o].anz_objekte, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 30, txt);
		startkette[o].anz_objekte = get_zahl(250, 30, startkette[o].anz_objekte);
		strcpy(txt, "KETTENABSTAND (");
		itoa(startkette[o].obj.startpause, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 40, txt);
		startkette[o].obj.startpause = get_zahl(250, 40, startkette[o].obj.startpause);
		strcpy(txt, "X-STARTPOSITION (");
		itoa(startkette[o].obj.bahn.x / KURVENFAC, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 50, txt);
		startkette[o].obj.bahn.x = get_zahl(250, 50, startkette[o].obj.bahn.x / KURVENFAC) * KURVENFAC;
		strcpy(txt, "Y-STARTPOSITION (");
		itoa(startkette[o].obj.bahn.y / KURVENFAC, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 60, txt);
		startkette[o].obj.bahn.y = get_zahl(250, 60, startkette[o].obj.bahn.y / KURVENFAC) * KURVENFAC;
		strcpy(txt, "OBJEKTBILDNUMMER (");
		itoa(startkette[o].obj.nr, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 70, txt);
		startkette[o].obj.nr = get_zahl(250, 70, startkette[o].obj.nr);
		strcpy(txt, "ANIMATIONSSTUFEN (");
		itoa(startkette[o].obj.anz_anistufen, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 80, txt);
		startkette[o].obj.anz_anistufen = get_zahl(250, 80, startkette[o].obj.anz_anistufen);
		strcpy(txt, "ENERGIE (");
		itoa(startkette[o].obj.energie, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 90, txt);
		startkette[o].obj.energie = get_zahl(250, 90, startkette[o].obj.energie);
		strcpy(txt, "FEUERGESCHW. (");
		itoa(startkette[o].obj.weapon_fire, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 100, txt);
		startkette[o].obj.weapon_fire = get_zahl(250, 100, startkette[o].obj.weapon_fire);
		strcpy(txt, "EXTRA (");
		itoa(startkette[o].obj.extra, str, 10);
		strcat(txt, str);
		strcat(txt, "): ");
		put_text(&schrift, 0, 110, txt);
		startkette[o].obj.extra = get_zahl(250, 110, startkette[o].obj.extra);

		edit_kette = o;
		edit_kurve = 0;
	}
}

void loesche_startkette(int such_x)
{
	int i, o, min_pos;

	o = 0;
	min_pos = 1000000;
	for(i = 0; i < ANZ_LEVELKETTEN; i++)
		if(startkette[i].start_x > such_x)
			if(startkette[i].start_x < min_pos)
			{
				min_pos = startkette[i].start_x;
				o = i;
			}

	if(min_pos < 1000000)
	{
		if(edit_kette == o)
			edit_kette = -1;
		startkette[o].start_x = 0;
	}
}

void editor_hilfe(void)
{
	cls(0);

	put_text(&schrift, 0, 0 * schrift.char_h, "                 EDITOR - HELP:");
	put_text(&schrift, 0, 1 * schrift.char_h, "LOAD LEVEL   - L");
	put_text(&schrift, 0, 2 * schrift.char_h, "SAVE LEVEL   - S");
	put_text(&schrift, 0, 3 * schrift.char_h, "LEVELNUMBER  - N/SHIFT N"); 
	put_text(&schrift, 0, 4 * schrift.char_h, "NEW GROUP    - SPACE");
	put_text(&schrift, 0, 5 * schrift.char_h, "EDIT GROUP   - ENTER");
	put_text(&schrift, 0, 6 * schrift.char_h, "EDIT PLATFORMS - A");
	put_text(&schrift, 0, 7 * schrift.char_h, "DELETE GROUP - DEL");
	put_text(&schrift, 0, 8 * schrift.char_h, "CHANGE GROUPX - TAB/SHIFT TAB");
	put_text(&schrift, 0, 9 * schrift.char_h, "NEW CLOUD    - W");
	put_text(&schrift, 0, 10 * schrift.char_h, "NEW PLATFORM - P");
	put_text(&schrift, 0, 11 * schrift.char_h, "NEW FIRESTAT - G");
	put_text(&schrift, 0, 12 * schrift.char_h, "NEW ROCKETS  - R");
	put_text(&schrift, 0, 13 * schrift.char_h, "NEW DREHKETTE- K");
	put_text(&schrift, 0, 14 * schrift.char_h, "TEST GROUP   - T");
	put_text(&schrift, 0, 15 * schrift.char_h, "PICNUMBER    - B/SHIFT B");
	put_text(&schrift, 0, 16 * schrift.char_h, "SUB CURVE XY - UP");
	put_text(&schrift, 0, 17 * schrift.char_h, "ADD CURVE XY - DOWN");
	put_text(&schrift, 0, 18 * schrift.char_h, "SCROLLPOS    - LEFT/RIGHT");
	put_text(&schrift, 0, 19 * schrift.char_h, "CURVEPARAMS  - NUMPAD");
	put_text(&schrift, 0, 20 * schrift.char_h, "SHIFTSCALE...- SHIFT, CTRL, ALT");
	put_text(&schrift, 0, 21 * schrift.char_h, "SELECT ACTIVE CURVE- RCTRL");
	put_text(&schrift, 0, 22 * schrift.char_h, "TOGGLE CURVE SCROLLING- RSHIFT");
	put_text(&schrift, 0, 23 * schrift.char_h, "PLAY GAME    - F10");
	put_text(&schrift, 0, 24 * schrift.char_h, "RESET LEVEL  - POS1/HOME");

	Copy2Screen();
	while(!keyTest(KEY_SPACE) && !keyTest(KEY_ENTER) && !keyTest(KEY_ESC))
		;
	while(keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_ESC))
		;
	cls(0);

	put_text(&schrift, 0, 0 * schrift.char_h, "                 EDITOR - HELP:");
	put_text(&schrift, 0, 1 * schrift.char_h, "COPY GROUP    - SHIFT + INSERT/EINFG");
	put_text(&schrift, 0, 2 * schrift.char_h, "PASTE GROUP   - INSERT/EINFG");

	Copy2Screen();
	while(!keyTest(KEY_SPACE) && !keyTest(KEY_ENTER) && !keyTest(KEY_ESC))
		;
	while(keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_ESC))
		;
}

void editor_tasten(void)
{
	int i;

	if(keyTest(KEY_H) || keyTest(KEY_F1))
	{
		editor_hilfe();
		delay(150);
	}
	else if((keyTest(KEY_LSHIFT)) && (keyTest(KEY_INSERT)))
	{
		if ( edit_kette > -1 ) 
			paste = startkette[edit_kette];
		delay(150);
	}
	else if(keyTest(KEY_INSERT))
	{
		i = 0;
		while((i < ANZ_LEVELKETTEN) && startkette[i].start_x)
			i++;

		if(i <= ANZ_LEVELKETTEN)
		{
			startkette[i ] = paste;
			startkette[i].start_x = game_scrollpos;
			if(i >= anz_ketten)
				anz_ketten = i + 1;
		}
		delay(150);
	}
	else if(keyTest(KEY_A))
	{
		edit_platforms();
	}
	else if(keyTest(KEY_N))
	{
		if(keyTest(KEY_LSHIFT))
		{
			game_level++;
		}
		else if(game_level > 0)
		{
			game_level--;
		}
		delay(150);
	}
	else if(keyTest(KEY_S))
	{
		save_level(game_level);
		delay(150);
	}
	else if(keyTest(KEY_RSHIFT))
	{
		scroll = 1 - scroll;
		delay(100);
	}
	else if(keyTest(KEY_L))
	{
		load_level(game_level);
		delay(150);
	}
	else if(keyTest(KEY_ENTER))
	{
		delay(150);
		edit_startkette(game_scrollpos);
	}
	else if(keyTest(KEY_DELETE))
	{
		loesche_startkette(game_scrollpos);
		delay(150);
	}
	else if(keyTest(KEY_TAB))
	{
		if(keyTest(KEY_LSHIFT))
			startkette[edit_kette].start_x -= 10;
		else
			startkette[edit_kette].start_x += 10;
		delay(150);
	}
	else if(keyTest(KEY_LEFT))
	{
		if(keyTest(KEY_LSHIFT))
			game_scrollpos -= 100;
		else if(keyTest(KEY_LALT))
			game_scrollpos -= 50;
		else if(keyTest(KEY_LCTRL))
			game_scrollpos -= 10;
		else
			game_scrollpos--;

		if(game_scrollpos < 0)
			game_scrollpos = 0;
		delay(150);
	}
	else if(keyTest(KEY_RIGHT))
	{
		if(keyTest(KEY_LSHIFT))
			game_scrollpos += 100;
		else if(keyTest(KEY_LALT))
			game_scrollpos += 50;
		else if(keyTest(KEY_LCTRL))
			game_scrollpos += 10;
		else
			game_scrollpos++;

		// Stimmt diese Begrenzung?
		if(game_scrollpos > (MAX_PLATFORMBREITE - 320 / 40) * 40)
			game_scrollpos = (MAX_PLATFORMBREITE - 320 / 40) * 40;
		delay(150);
	}
	else if(keyTest(KEY_SPACE))
	{
		neue_startkette(game_scrollpos, 0);
		delay(150);
	}
	else if(keyTest(KEY_W))
	{
		neue_startkette(game_scrollpos, 1);
		delay(150);
	}
	else if(keyTest(KEY_P))
	{
		neue_startkette(game_scrollpos, 2);
		delay(150);
	}
	else if(keyTest(KEY_G))
	{
		neue_startkette(game_scrollpos, 3);
		delay(150);
	}
	else if(keyTest(KEY_R))
	{
		neue_startkette(game_scrollpos, 4);
		delay(150);
	}
	else if(keyTest(KEY_K))
	{
		neue_startkette(game_scrollpos, 5);
		delay(150);
	}

	if(edit_kette > -1)
	{
		// testen
		if(keyTest(KEY_T))
		{
			scroll = 0;
			zeichne_bahn(&startkette[edit_kette].obj, startkette[edit_kette].start_x - game_scrollpos, TRUE, 48);
			scroll = 1;
		}
		// Bildnummer

		if(keyTest(KEY_RCTRL))
		{
			if (edit_kurve > -1)
				edit_kurve = -1;
			else
        edit_kurve = 0;
			delay(50);
		}
		if(keyTest(KEY_B))
		{
			if(keyTest(KEY_LSHIFT))
				startkette[edit_kette].obj.nr--;
			else
				startkette[edit_kette].obj.nr++;
			delay(150);
		}
		// y/x ndern
		if(keyTest(KEY_UP))
		{
			if(keyTest(KEY_LSHIFT))
				startkette[edit_kette].obj.bahn.x -= 10;
			else
				startkette[edit_kette].obj.bahn.y -= 10;
			delay(150);
		}
		if(keyTest(KEY_DOWN))
		{
			if(keyTest(KEY_LSHIFT))
				startkette[edit_kette].obj.bahn.x += 10;
			else
				startkette[edit_kette].obj.bahn.y += 10;
			delay(150);
		}
		// Kurvenparameter aendern
		if(edit_kurve > -1)
		{
			// kurve_nr
			if(keyTest(KEY_PADSLASH) && (edit_kurve < MAX_KURVEN))
			{
				if(startkette[edit_kette].obj.bahn.anz == edit_kurve + 1)
				{
					// neue Kurve dazu
					startkette[edit_kette].obj.bahn.anz++;
					kurven_ende_neue(&startkette[edit_kette].obj.bahn, &edit_kurve);
				}
				else
					edit_kurve++;
				delay(150);
			}
			else if(keyTest(KEY_PADSTAR))
			{
				if(edit_kurve > 0)
					edit_kurve--;
				delay(150);
			}
			// len
			if(keyTest(KEY_PADPLUS))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].len += 10;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].len++;
				delay(150);
			}
			if(keyTest(KEY_PADMINUS))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].len -= 10;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].len--;
				if(startkette[edit_kette].obj.bahn.kurve[edit_kurve].len < 0)
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].len = 0;
				delay(150);
			}
			// pls
			if(keyTest(KEY_PAD7))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].xpl += KURVENFAC;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].xpl += 1;
				delay(150);
			}
			else if(keyTest(KEY_PAD4))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].xpl -= KURVENFAC;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].xpl -= 1;
				delay(150);
			}
			if(keyTest(KEY_PAD8))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].ypl += KURVENFAC;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].ypl += 1;
				delay(150);
			}
			else if(keyTest(KEY_PAD5))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].ypl -= KURVENFAC;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].ypl -= 1;
				delay(150);
			}
			// plpls
			if(keyTest(KEY_PAD9))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].xxpl += KURVENFAC;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].xxpl += 1;
				delay(150);
			}
			else if(keyTest(KEY_PAD6))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].xxpl -= KURVENFAC;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].xxpl -= 1;
				delay(150);
			}
			if(keyTest(KEY_PAD1))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].yypl += KURVENFAC;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].yypl += 1;
				delay(150);
			}
			else if(keyTest(KEY_PAD2))
			{
				if(keyTest(KEY_LSHIFT))
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].yypl -= KURVENFAC;
				else
					startkette[edit_kette].obj.bahn.kurve[edit_kurve].yypl -= 1;
				delay(150);
			}
			// Kurve reset
			if(keyTest(KEY_PAD0))
			{
				startkette[edit_kette].obj.bahn.kurve[edit_kurve].len = 10;
				startkette[edit_kette].obj.bahn.kurve[edit_kurve].xpl = -1 * KURVENFAC;
				startkette[edit_kette].obj.bahn.kurve[edit_kurve].ypl = 0;
				startkette[edit_kette].obj.bahn.kurve[edit_kurve].xxpl = 0;
				startkette[edit_kette].obj.bahn.kurve[edit_kurve].yypl = 0;
			}
		}
	}
}

void show_starts(void)
{
	int i;

	for(i = 0; i < ANZ_LEVELKETTEN; i++)
		if(startkette[i].start_x)
		{
			if((startkette[i].start_x >= game_scrollpos) && (startkette[i].start_x <= game_scrollpos + screen_width - 1))
			{
				strcpy(txt, "+");
				itoa(i, str, 10);
				strcat(txt, str);
				put_text(&schrift, startkette[i].start_x - game_scrollpos, screen_height / 2, txt);
				if(startkette[i].obj.art == 0)
					strcpy(txt, "W");
				else if(startkette[i].obj.art == 1)
					strcpy(txt, "P");
				else if((startkette[i].obj.art == 6) || (startkette[i].obj.art == 11))
					strcpy(txt, "T");
				else if(startkette[i].obj.art == 8)
					strcpy(txt, "R");
				else if(startkette[i].obj.art == 16)
					strcpy(txt, "K");
				else
					strcpy(txt, "G");
				put_text(&schrift, startkette[i].start_x - game_scrollpos, screen_height / 2 + schrift.char_h, txt);
			}
		}
}

void zeichne_bahn(OBJEKT *obj, int start_x, BOOLEAN fliegen, int color)
{
	int pos, i;
	int x, y, xpl, ypl, xxpl, yypl;
	int pixnr;
	int alt_game_scrollpos;
	long t;


	alt_game_scrollpos = game_scrollpos;
	x = obj->bahn.x + start_x * KURVENFAC; // start_x zum Scrollen im Editor
	y = obj->bahn.y;
	// hier bahn... nicht umsetzen
	for(pos = 0; pos < obj->bahn.anz; pos++)
	{
		xpl = obj->bahn.kurve[pos].xpl;
		ypl = obj->bahn.kurve[pos].ypl;
		xxpl = obj->bahn.kurve[pos].xxpl;
		yypl = obj->bahn.kurve[pos].yypl;
		
		for(i = 0; i < obj->bahn.kurve[pos].len; i++)
		{
			/*mitscrollen  eingefuegt von uh*/
			if(scroll)
			{
				x += KURVENFAC;
			}

			if(!fliegen)
			{
				if((color > 31) && (edit_kurve == pos))
					PutPixel(x / KURVENFAC, y / KURVENFAC, color + 32);
				else
					PutPixel(x / KURVENFAC, y / KURVENFAC, color);
			}
			else
			{
				t = timer();
				while(timer() - t < 3)
					;
				game_scrollpos++;
				hintergrund();
				pixnr = obj->nr + obj->anistufe / ANIFAC;
				objput(x / KURVENFAC - objpix[pixnr].w / 2, y / KURVENFAC - objpix[pixnr].h / 2, &objpix[pixnr]);
				Copy2Screen();
			}
			x += xpl / KURVENFAC;
			y += ypl / KURVENFAC;
			xpl += xxpl;
			ypl += yypl;
		}
	}
	game_scrollpos = alt_game_scrollpos;
}

void zeige_kette(void)
{
	if(edit_kette > -1)
	{
		if(edit_kurve > -1)
			zeichne_bahn(&startkette[edit_kette].obj, startkette[edit_kette].start_x - game_scrollpos, FALSE, 48 + 32);
		else
			zeichne_bahn(&startkette[edit_kette].obj, startkette[edit_kette].start_x - game_scrollpos, FALSE, 48);
	}
}

void editor_info(void)
{
	sprintf(txt, "EDIT LVL: %d POS: %d ", game_level, game_scrollpos);
	if(edit_kette > -1)
	{
		strcat(txt, "KETTE: ");
		itoa(edit_kette, str, 10);
		strcat(txt, str);
		if(edit_kurve > -1)
		{
			strcat(txt, "/");
			itoa(edit_kurve, str, 10);
			strcat(txt, str);
		}
	}
	put_text(&schrift, 0, 0, txt);
	if(scroll)
		put_text(&schrift, 260, 0, "SCR ON");
	else
		put_text(&schrift, 260, 0, "SCR OFF");
}

void save_level(int level)
{
	FILE *datei;
	int i;
	char txt[80];

	if(game_difficulty == TRAINING)
		sprintf(txt, "DATA\\TRAINING.DAT");
	else
		sprintf(txt, "DATA\\LEVEL%d.DAT", level + 1);
	datei = fopen(txt, "wb");
	if(datei)
	{
		fwrite(&anz_ketten, 1, 4, datei);
		for(i = 0; i < anz_ketten; i++)
			fwrite(&startkette[i], 1, sizeof(KETTENSTART), datei);

		fwrite(&max_platform, 4, 1, datei);
		fwrite(&platform[0][0], 4, 5 * max_platform, datei);

		fclose(datei);
	}
	else
		puts("\7");
}

BOOLEAN load_level(int level)
{
	FILE *datei;
	int i;
	char txt[80];

	// Level initialisieren
	anz_ketten = 0;
	for(i = 0; i < ANZ_LEVELKETTEN; i++)
		memset(&startkette[i], 0, sizeof(startkette[i]));
	max_platform = 0;

	if(game_difficulty == TRAINING)
		sprintf(txt, "TRAINING.DAT");
	else
		sprintf(txt, "LEVEL%d.DAT", level + 1);
	datei = open_file(txt);
	if(datei)
	{
		fread(&anz_ketten, 4, 1, datei);
		for(i = 0; i < anz_ketten; i++)
		{
			fread(&startkette[i], sizeof(KETTENSTART), 1, datei);
			// Wegen Fehlern alles mal richtigsetzen
			startkette[i].obj.anistufe = 0;
		}

		fread(&max_platform, 4, 1, datei);
		fread(platform, 4, 5 * max_platform, datei);

		fclose(datei);

		return(TRUE);
	}

	return(FALSE);
}

int bildnummereingabe(int x, int y, int nr)
{
	while(!keyTest(KEY_ENTER) && !keyTest(KEY_PADENTER))
	{
		if(keyTest(KEY_PADPLUS))
		{
			if(keyTest(KEY_LSHIFT))
				nr += 10;
			else
				nr += 1;
			delay(150);
		}
		else if(keyTest(KEY_PADMINUS))
		{
			if(keyTest(KEY_LSHIFT) && (nr >= 10))
				nr -= 10;
			else if(keyTest(KEY_LSHIFT))
				nr = 0;
			else if(nr > 0)
				nr -= 1;
			delay(150);
		}
		objput(x, y, &objpix[nr]);
		Copy2Screen();
	}
	delay(150);

	return(nr);
}

int extraeingabe(int x, int y, int nr)
{
	while(!keyTest(KEY_ENTER) && !keyTest(KEY_PADENTER))
	{
		if(keyTest(KEY_PADPLUS))
		{
			nr += 1;
			delay(150);
		}
		else if(keyTest(KEY_PADMINUS))
		{
			if(nr > 0)
				nr -= 1;
			delay(150);
		}
		show_text(&schrift, x, y, "          ");
		switch(nr)
		{
			case 0:
				put_text(&schrift, x, y, "NOTHING");
				break;
			case 1:
				put_text(&schrift, x, y, "LASER");
				break;
			case 2:
				put_text(&schrift, x, y, "SHIELD");
				break;
			case 3:
				put_text(&schrift, x, y, "ROCKETS");
				break;
			case 4:
				put_text(&schrift, x, y, "BOMB");
				break;
			case 5:
				put_text(&schrift, x, y, "ENERGY");
				break;
			case 6:
				put_text(&schrift, x, y, "DEATH");
				break;
			case 7:
				put_text(&schrift, x, y, "V-SHOT");
				break;
			case 8:
				put_text(&schrift, x, y, "MINES");
				break;
			case 9:
				put_text(&schrift, x, y, "POINTS");
				break;
			case 10:
				put_text(&schrift, x, y, "LIFE");
				break;
		}
		Copy2Screen();
	}
	delay(150);

	return(nr);
}
