/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*****************************************/
/* Prototypen der Funktionen fr TERROID */
/* (C) Juli 1996 by Michael Haar         */
/*****************************************/

// editor
extern void init_editor();
extern void editor_tasten();
extern void show_starts();
extern void zeige_kette();
extern void editor_info();
extern void save_level(int level);
extern BOOLEAN load_level(int level);
extern void show_ketten();
// explo
extern void reset_explosionen();
extern BOOLEAN init_explos(unsigned char level);
extern void explode(int x, int y, int w, int h, unsigned char art);
extern void explosionen();
extern void erzeuge_schrott(int x, int y);
// extras
extern BOOLEAN extras_init(unsigned char level);
extern int extra_start(int anz, int art);
extern void extra_new(int nr, int x, int y, int art);
extern void extras();
// hintergrund
extern BOOLEAN init_hintergrund(unsigned char level);
extern void hintergrund();
extern BOOLEAN init_bg(unsigned char level) ;
extern void background(void) ;
// init
extern BOOLEAN init_game();
extern void exit_game();
extern void start_game(unsigned char level);
extern void naechstes_level();
// kollision
extern void standardkollision(OBJEKT *obj);
extern void schusskollision(OBJEKT *obj);
// main
extern void paused_effect();
extern BOOLEAN play_fli(char *fname, BOOLEAN endlos, long wait_time);
// objekte
extern BOOLEAN init_objekte(unsigned char level);
extern void show_attack();
extern void neue_objekte();
extern void objekte();
extern void show_objekt(OBJEKT *obj);
extern void delete_objekt(OBJEKT *obj);
extern void wolken();
extern void kill_all_objects();
extern BOOLEAN alle_tot(OBJEKT *obj);
extern void alles_sprengen(int x, int y, int radius);
// platforms
extern BOOLEAN init_platforms(int level);
extern void plattformen();
extern void show_platforms();
extern void edit_platforms();
// schiessen
extern int zielrakete_gegnersuchen();
extern void neuer_schuss(int x, int y, unsigned char r, unsigned char art);
extern void schiessen(OBJEKT *obj);
// spieler
extern BOOLEAN init_spieler(unsigned char level);
extern void spieleraction();
extern void infobalken();
// steuern
extern int winkel(int dx, int dy);
extern void set_richtung(FLUGBAHN *bahn, unsigned char k, unsigned char r, unsigned char speed);
extern unsigned char get_richtung(FLUGBAHN *bahn, unsigned char k);
extern void standardsteuern(OBJEKT *obj);
extern void schnellanisteuern(OBJEKT *obj);
extern void kippsteuern(OBJEKT *obj);
extern void drehsteuern(OBJEKT *obj);
extern int ziel_richtung(FLUGBAHN *bahn);
extern void schiffrichtung_zielsteuern(OBJEKT *obj);
extern void spieler_zielraketen_steuern(OBJEKT *obj);
extern void raketenturmsteuern(OBJEKT *obj);
extern void zielraketensteuern(OBJEKT *obj);
extern void kanonenstellungsteuern(OBJEKT *obj);
extern void streusteuern(OBJEKT *obj);
extern void minesteuern(OBJEKT *obj);
extern void schrottsteuern(OBJEKT *obj);
extern void kettesteuern(OBJEKT *obj);
extern void restartsteuern(OBJEKT *obj);
extern void bisallestot_endgegnersteuern(OBJEKT *obj);
extern void spielersuchsteuern(OBJEKT *obj);
extern void zerbatzsteuern(OBJEKT *obj);
extern void mittelschnellsteuern(OBJEKT *obj);
extern void minilaunchersteuern(OBJEKT *obj);
extern void abstossersteuern(OBJEKT *obj);
extern void magnetsteuern(OBJEKT *obj);
// startmnu
void viewoptions();
void schwierigkeit();
extern BOOLEAN startmenu();
extern BOOLEAN buy_continue();
// intro
extern int do_intro();
// engegne
extern void endgegner_start(OBJEKT *obj);
extern void endgegner_specialaction(KETTENSTART *startkette);
extern BOOLEAN endgegner_treffbar(OBJEKT *obj);
extern int endgegner_energie();
extern void endgegner_restarten(OBJEKT *obj);
extern void endgegner_tot(OBJEKT *obj);
extern BOOLEAN endgegner4_rakwerfer_da();
extern BOOLEAN endgegner1_kanonen_da();
// krams
extern void clear_keys();
extern void wait_keys(long bis);
extern void press_key(long bis);
extern void pixel_in(void *pix);
extern void PaletteWhiteOut(RGB pal[256]);
extern void PaletteWhiteIn(RGB pal[256]);
extern void ticker_text(FONT *font, int x, int y, const char *txt, BOOLEAN mark);
// hiscore
extern void hiscore();
// stars
extern void init_sterne();
extern void sterne();
// story
extern void story_text(FONT *font, const char *txt);
extern void story();
extern void training_story();
extern void ende_story();
extern void orbit_story();
extern void wueste_story();
extern void city_story();
extern void demo_story() ;
// extro
extern void extro();
// bonus
void bonusgame(int level);
