/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/* Definitionen fr das ballerspiel */

/* Defines */
#define PI 3.141593

#define GFXMODE 0x13

#define MAX_LEVEL 8

#define BODEN_SCROLLGESCHW (1 / 2)
#define MITTE_SCROLLGESCHW 1

#define ANZ_SPIELERPICS 5
#define SPIELER_WAFFEN 5

#define ANIFAC 8
#define KURVENFAC 8

#define SPEED_FAC 1

#define ANZ_OBJPICS 400
#define MAX_OBJEKTE 300

#define ANZ_LEVELKETTEN 1000
#define MAX_KURVEN 10

#define ANZ_EXPLOS 50
#define MAX_EXPLOS 100

#define EXTRA_ARTEN 5
#define ANZ_EXTRAPICS 100
#define ANZ_EXTRASTUFEN 6
#define MAX_EXTRAS 25

#define ANZ_HINTERGRUENDE 6

#define MAX_PLATFORMBREITE 200

// Bildernummerstarts
#define SCHUSSPICS 1
#define WOLKEPICS 25
#define PLATTFORMPICS 31
#define GEGNERPICS 35

// Spielersachen
#define MAX_PLAYERMINES 3
#define ANZ_LASERSTUFEN 6

#define ANZ_MODS 7

// Trainingsspiel
#define ATTACK_WAIT_LEN 150

/* Typen */
typedef struct
{
	int anistufe;
	int x, y;
	int xpl, ypl;
	int speed;
	int waffe_ok[SPIELER_WAFFEN];
	int waffe[SPIELER_WAFFEN];
	int energie;
	int leben;
	int punkte;
	int smartbomb;
	int schild;
	int powerbeam;
	int absturz;
	struct
	{
		int x, y;
		int energie;
	} mine[MAX_PLAYERMINES];
} SPIELER;

typedef struct
{
	int len;
	int xpl, ypl;
	int xxpl, yypl;
} KURVE;

typedef struct
{
	int anz;
	int akt;
	int x, y;
	KURVE kurve[MAX_KURVEN];
} FLUGBAHN;

typedef struct
{
	int nr;
	int art;
	int anistufe;
	int anz_anistufen;
	int startpause;
	FLUGBAHN bahn;
	int energie;
	int extra_listnr;
	int weapon_ok;
	int weapon_fire;
	int extra;
} OBJEKT;

typedef struct
{
	int nr;
	int anistufe;
	int x, y;
	int w, h;
} EXPLOSION;

typedef struct
{
	int start_x;
	int anz_objekte;
	OBJEKT obj;
} KETTENSTART;

typedef struct
{
	int nr;
	int anistufe;
	int x, y;
	int komm_zaehler;
} EXTRA;

typedef struct
{
	int energie_max;
	int energie_aktuell;
	int art_da;
	int start_x;
} ENDMONSTER;

typedef enum {PLAY, EDIT, DEMO} PLAYMODE;
typedef enum { FULL, HIGH, MEDIUM, MINI } GAMEVIEW;
typedef enum { BABY, BEGINNER, NORMAL, TRAINING } GAMEDIFFICULTY;

typedef struct
{
	int nr;
	int wait;
	int dauer;
} ATTACK_WAVE;
