Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. No modifications intended to allow the software to be used within the
   Ms-Dos and Windows operating systems may be distributed with, or
   applied to, the source code or binary form of the software.
6. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
7. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/**********************************/
/* NewOnlyOne-Maker (C) Juli 1996 */
/* by Michael Haar                */
/**********************************/

#include <stdio.h>
#include <string.h>
#include <dn.h>

#define MAX_FILES 1000

/* globale Variablen */
ONLYONEHEADER head;
ONLYONE_ENTRY found_entry[MAX_FILES];

/* Funktionsprotypen */
extern long filesize(FILE *fp);

/* Funktionen */
void add_data(FILE *onlyone, ONLYONEHEADER head)
{
	FILE *datei;
	int i;
	int pos;
	char data;
	char * realname;

	for(i = 0; i < head.entries; i++)
	{
		fseek(onlyone, sizeof(ONLYONEHEADER) + i * sizeof(ONLYONE_ENTRY), SEEK_SET);
		fwrite(&found_entry[i], sizeof(ONLYONE_ENTRY), 1, onlyone);

		// Data kopieren
		fseek(onlyone, found_entry[i].startpos, SEEK_SET);
		realname = found_entry[i].filename;
		printf("Datei: %s - ", realname);
		datei = fopen(realname, "rb");
		if(datei)
		{
			for(pos = 0; pos < found_entry[i].length; pos++)
			{
				fread(&data, 1, 1, datei);
				fwrite(&data, 1, 1, onlyone);
			}
			fclose(datei);
			printf("OK\n");
		}
		else
			printf("Fehler\n");
	}
}

long datei_groesse(const char *fname)
{
	FILE *datei;
	long l = 0;

	datei = fopen(fname, "rb");
	if(datei)
	{
		l = filesize(datei);
		fclose(datei);
	}

	return(l);
}

void write_datafiles(FILE *onlyone)
{
	char searchpath[1024];
	struct find_t find;
	int r;
	int writepos;

	// Anzahl bestimmen:
	printf("Suche Dateien ...\n");
	head.id[0] = head.id[1] = 'O';
	head.entries = 0;
	writepos = 0;
	strcpy(searchpath, "*.*");
	r = _dos_findfirst(searchpath, _A_NORMAL, &find);
	while(r == 0)
	{
		// Irgendwas gefunden:
		if(strcmp(find.name, "only.one") && strcmp(find.name, "oomake.exe") && strcmp(find.name, "ONLY.ONE") && strcmp(find.name, "OOMAKE.EXE"))
		{
			strcpy(found_entry[head.entries].filename, find.name);
			strlwr(found_entry[head.entries].filename);
			found_entry[head.entries].startpos = writepos;
			found_entry[head.entries].length = datei_groesse(found_entry[head.entries].filename);
			writepos += found_entry[head.entries].length;
			printf("Datei: %s - %d Bytes\n", found_entry[head.entries].filename, found_entry[head.entries].length);
			head.entries++;
		}
		// und weiter ...
		r = _dos_findnext(&find);
	}
	_dos_findclose(&find);

	// Header schreiben:
	fwrite(&head, sizeof(ONLYONEHEADER), 1, onlyone);
	printf("%d Dateien gefunden ...\n", head.entries);

	// Um Entrytabellenlaenge erhoehen
	for(r = 0; r < head.entries; r++)
		found_entry[r].startpos += sizeof(ONLYONEHEADER) + head.entries * sizeof(ONLYONE_ENTRY);

	// Data schreiben:
	printf("\nKopiere Data ...\n");
	add_data(onlyone, head);
}

int main()
{
	FILE *onlyone;
	int i;
	char * realname;

	printf("only.one - Maker (C) Juli 1996 - Michael Haar, DIGITAL Nightmares\n");
	printf("-----------------------------------------------------------------\n");
	printf("Erzeuge neue only.one ...\n\n");

	// Neu anlegen
	onlyone = fopen("only.one", "wb");
	if(onlyone == NULL)
		return(-1);

	// Dateien schreiben
	write_datafiles(onlyone);

	printf("\nDatei fertig!\n\n");
	fclose(onlyone);

/*	printf("TEST:\n");
	for(i = 0; i < head.entries; i++)
	{
		realname = found_entry[i].filename;

		printf("Datei: %s - ", realname);
		onlyone = open_file(realname);
		if(onlyone)
		{
			if(filestartpos > 0)
				printf("%d Bytes, OK\n", filelength);
			else
				printf("Fehler\7\n");
			fclose(onlyone);
		}
		else
			printf("Megafehler\7\n");
	} */

	return(0);
}
