#ifndef __DN_KEY_H
  #define __DN_KEY_H

#ifdef MSDOS

/* key make codes */
#define KEY_ESC                 0x01
#define KEY_1                   0x02
#define KEY_2                   0x03
#define KEY_3                   0x04
#define KEY_4                   0x05
#define KEY_5                   0x06
#define KEY_6                   0x07
#define KEY_7                   0x08
#define KEY_8                   0x09
#define KEY_9                   0x0A
#define KEY_0                   0x0B
#define KEY_MINUS               0x0C
#define KEY_EQUALS              0x0D
#define KEY_PLUS                0x0D
#define KEY_BACKSPACE   	0x0E
#define KEY_TAB                 0x0F
#define KEY_Q                   0x10
#define KEY_W                   0x11
#define KEY_E                   0x12
#define KEY_R                   0x13
#define KEY_T                   0x14
#define KEY_Y                   0x15
#define KEY_U                   0x16
#define KEY_I                   0x17
#define KEY_O                   0x18
#define KEY_P                   0x19
#define KEY_LBRACE              0x1A
#define KEY_RBRACE              0x1B
#define KEY_ENTER               0x1C
#define KEY_LCTRL               0x1D
#define KEY_A                   0x1E
#define KEY_S                   0x1F
#define KEY_D                   0x20
#define KEY_F                   0x21
#define KEY_G                   0x22
#define KEY_H                   0x23
#define KEY_J                   0x24
#define KEY_K                   0x25
#define KEY_L                   0x26
#define KEY_SEMICOLON   	0x27
#define KEY_APOSTROPHE  	0x28
#define KEY_TILDE               0x29
#define KEY_LSHIFT              0x2A
#define KEY_BACKSLASH   	0x2B
#define KEY_Z                   0x2C
#define KEY_X                   0x2D
#define KEY_C                   0x2E
#define KEY_V                   0x2F
#define KEY_B                   0x30
#define KEY_N                   0x31
#define KEY_M                   0x32
#define KEY_COMMA               0x33
#define KEY_PERIOD              0x34
#define KEY_SLASH               0x35
#define KEY_RSHIFT              0x36
#define KEY_PADSTAR             0x37
#define KEY_LALT                0x38
#define KEY_SPACE               0x39
#define KEY_CAPSLOCK    	0x3A
#define KEY_F1                  0x3B
#define KEY_F2                  0x3C
#define KEY_F3                  0x3D
#define KEY_F4                  0x3E
#define KEY_F5                  0x3F
#define KEY_F6                  0x40
#define KEY_F7                  0x41
#define KEY_F8                  0x42
#define KEY_F9                  0x43
#define KEY_F10                 0x44
#define KEY_NUMLOCK             0x45
#define KEY_SCROLLLOCK  	0x46
#define KEY_PAD7                0x47
#define KEY_PADHOME             0x47
#define KEY_PAD8                0x48
#define KEY_PADUP               0x48
#define KEY_PAD9                0x49
#define KEY_PADPAGEUP   	0x49
#define KEY_PADMINUS    	0x4A
#define KEY_PAD4                0x4B
#define KEY_PADLEFT             0x4B
#define KEY_PAD5                0x4C
#define KEY_PAD6                0x4D
#define KEY_PADRIGHT    	0x4D
#define KEY_PADPLUS     	0x4E
#define KEY_PAD1                0x4F
#define KEY_PADEND              0x4F
#define KEY_PAD2                0x50
#define KEY_PADDOWN     	0x50
#define KEY_PAD3                0x51
#define KEY_PADPAGEDN   	0x51
#define KEY_PAD0        	0x52
#define KEY_PADINSERT   	0x52
#define KEY_PADPERIOD   	0x53
#define KEY_PADDELETE   	0x53
#define KEY_SYSREQ              0x54

#define KEY_F11                 0x57
#define KEY_F12                 0x58

#ifdef __WATCOMC__

#define KEY_PADENTER    	0x9C
#define KEY_RCTRL               0x9D
#define KEY_PADSLASH    	0xB5
#define KEY_PRINTSCREEN 	0xB7
#define KEY_RALT                0xB8
#define KEY_PAUSE               0xC5
#define KEY_HOME                0xC7
#define KEY_UP                  0xC8
#define KEY_PAGEUP              0xC9
#define KEY_LEFT                0xCB
#define KEY_RIGHT               0xCD
#define KEY_END                 0xCF
#define KEY_DOWN                0xD0
#define KEY_PAGEDN              0xD1
#define KEY_INSERT              0xD2
#define KEY_DELETE              0xD3

#else if defined (__GNUC__)
/* Allegro can't handle extended keyboard stuff. A shame. */

#define KEY_PADENTER    	0x1C
#define KEY_RCTRL               0x1D
#define KEY_PADSLASH    	0x35
#define KEY_PRINTSCREEN 	0x37
#define KEY_RALT                0x38
#define KEY_PAUSE               0x45
#define KEY_HOME                0x47
#define KEY_UP                  0x48
#define KEY_PAGEUP              0x49
#define KEY_LEFT                0x4B
#define KEY_RIGHT               0x4D
#define KEY_END                 0x4F
#define KEY_DOWN                0x50
#define KEY_PAGEDN              0x51
#define KEY_INSERT              0x52
#define KEY_DELETE              0x53

#endif /* defined __WATCOMC__ */

#ifdef __GNUC__

  extern volatile char key[128] ;
  extern void install_keyboard()
  
  #define keyFlags key
  #define keyInstall() install_keyboard()
  #define keyRemove()
  #define keyTest(c) ( (int) (key[ ( (int) (c))] != 0))

#else /* not __GNUC__ */

  extern volatile unsigned char KeyFlags[256];

int keyTest(char c);
int keyGet(char c);
void keyRemove();
void keyInstall();

#endif /* defined (__GNUC__) */

#else if defined (unix)

#include <X11/keysym.h>

/* key make codes */
#define KEY_ESC                 XK_Escape
#define KEY_1                   XK_1
#define KEY_2                   XK_2
#define KEY_3                   XK_3
#define KEY_4                   XK_4
#define KEY_5                   XK_5
#define KEY_6                   XK_6
#define KEY_7                   XK_7
#define KEY_8                   XK_8
#define KEY_9                   XK_9
#define KEY_0                   XK_0
#define KEY_MINUS               XK_minus
#define KEY_EQUALS              XK_equal
#define KEY_PLUS                XK_plus
#define KEY_BACKSPACE   	XK_BackSpace
#define KEY_TAB                 XK_Tab
#define KEY_Q                   XK_Q
#define KEY_W                   XK_W
#define KEY_E                   XK_E
#define KEY_R                   XK_R
#define KEY_T                   XK_T
#define KEY_Y                   XK_Y
#define KEY_U                   XK_U
#define KEY_I                   XK_I
#define KEY_O                   XK_O
#define KEY_P                   XK_P
#define KEY_LBRACE              XK_braceleft
#define KEY_RBRACE              XK_braceright
#define KEY_ENTER               XK_Return
#define KEY_LCTRL               XK_Control_L
#define KEY_A                   XK_A
#define KEY_S                   XK_S
#define KEY_D                   XK_D
#define KEY_F                   XK_F
#define KEY_G                   XK_G
#define KEY_H                   XK_H
#define KEY_J                   XK_J
#define KEY_K                   XK_K
#define KEY_L                   XK_L
#define KEY_SEMICOLON   	XK_semicolon
#define KEY_APOSTROPHE  	XK_apostrophe
#define KEY_TILDE               XK_asciitilde
#define KEY_LSHIFT              XK_Shift_L
#define KEY_BACKSLASH   	XK_backslash
#define KEY_Z                   XK_Z
#define KEY_X                   XK_X
#define KEY_C                   XK_C
#define KEY_V                   XK_V
#define KEY_B                   XK_B
#define KEY_N                   XK_N
#define KEY_M                   XK_M
#define KEY_COMMA               XK_comma
#define KEY_PERIOD              XK_period
#define KEY_SLASH               XK_slash
#define KEY_RSHIFT              XK_Shift_R
#define KEY_PADSTAR             XK_KP_Multiply
#define KEY_LALT                XK_Alt_L
#define KEY_SPACE               XK_space
#define KEY_CAPSLOCK    	XK_Caps_Lock
#define KEY_F1                  XK_F1
#define KEY_F2                  XK_F2
#define KEY_F3                  XK_F3
#define KEY_F4                  XK_F4
#define KEY_F5                  XK_F5
#define KEY_F6                  XK_F6
#define KEY_F7                  XK_F7
#define KEY_F8                  XK_F8
#define KEY_F9                  XK_F9
#define KEY_F10                 XK_F10
#define KEY_NUMLOCK             XK_Num_Lock
#define KEY_SCROLLLOCK  	XK_Scroll_Lock
#define KEY_PAD7                XK_KP_7
#define KEY_PADHOME             XK_KP_Home
#define KEY_PAD8                XK_KP_8
#define KEY_PADUP               XK_XP_Up
#define KEY_PAD9                XK_KP_9
#define KEY_PADPAGEUP   	XK_KP_Page_Up
#define KEY_PADMINUS    	XK_KP_Subtract
#define KEY_PAD4                XK_KP_4
#define KEY_PADLEFT             XK_KP_Left
#define KEY_PAD5                XK_KP_5
#define KEY_PAD6                XK_KP_6
#define KEY_PADRIGHT    	XK_KP_Right
#define KEY_PADPLUS     	XK_KP_Add
#define KEY_PAD1                XK_KP_1
#define KEY_PADEND              XK_KP_End
#define KEY_PAD2                XK_KP_2
#define KEY_PADDOWN     	XK_KP_Down
#define KEY_PAD3                XK_KP_3
#define KEY_PADPAGEDN   	XK_KP_Page_Down
#define KEY_PAD0                XK_KP_0
#define KEY_PADINSERT   	XK_KP_Insert
#define KEY_PADPERIOD   	XK_KP_Decimal	/* ? */
#define KEY_PADDELETE   	XK_KP_Delete
#define KEY_SYSREQ              XK_Sys_Req

#define KEY_F11                 XK_F11
#define KEY_F12                 XK_F12

#define KEY_PADENTER    	XK_KP_Enter
#define KEY_RCTRL               XK_Control_R
#define KEY_PADSLASH    	XK_KP_Divide
#define KEY_PRINTSCREEN 	XK_Print	/* ? */
#define KEY_RALT                XK_Alt_R
#define KEY_PAUSE               XK_Pause
#define KEY_HOME                XK_Home
#define KEY_UP                  XK_Up
#define KEY_PAGEUP              XK_Page_Up
#define KEY_LEFT                XK_Left
#define KEY_RIGHT               XK_Right
#define KEY_END                 XK_End
#define KEY_DOWN                XK_Down
#define KEY_PAGEDN              XK_Page_Down
#define KEY_INSERT              XK_Insert
#define KEY_DELETE              XK_Delete

  extern int keyFlags[256] ;
  #define keyInstall()				/* unused */
  #define keyRemove()

#endif /* defined (unix) */

#endif /* defined (__DN_KEY_H) */

