/* Types/Definitions for DN-GFX-Functions */

#ifndef __dn_types_h
  #define __dn_types_h

#include <mtypes.h>
#include <X11/Xlib.h>
#define UDWORD ULONG

#ifdef __WATCOMC__
  
  #define PI (double)3.14159265359
  #ifdef PACKED
    #undef PACKED
  #endif
  #define PACKED
  #define outportb(x, y) outp(x, y)
  #define inportb(x) inp(x)

#endif /* defined (__WATCOMC__) */

#ifdef __GNUC__

  #define min(x, y) ( (x) < (y) ? (x) : (y))
  #define max(x, y) ( (x) > (y) ? (x) : (y))
  #define PACKED __attribute ((packed))
  #ifdef __interrupt
    #undef __interrupt
  #endif
  #ifdef __far
    #undef __far
  #endif
  #define __interrupt
  #define __far

#endif /* defined (__GNUC__) */

#define _m_swap(x, y) x ^= y ; y ^= x ; x ^= y

#define FONT_CHARS (127 - 32 + 1) /* SPACE is first */
#define MAX_SCREEN_W 640
#define MAX_SCREEN_H 480
#define SINFAC 16

#define TICKS 91

typedef unsigned char BYTE ;
typedef signed short int WORD ;
typedef long DWORD;

typedef enum
{
	FALSE, TRUE
} BOOLEAN;

/* for put */

typedef struct
{
	WORD w, h;
	void *mem;
} OLDBLK;

typedef struct {
	Pixmap image ;
	Pixmap mask ;
	int w ;
	int h ;
} GFXBLK ;

/* for rle_get() and rle_put() */
typedef struct
{
    WORD w ;
    WORD h ;
    BYTE * mem ;
} RLEBLK ;

/* for palette */
typedef struct
{
	BYTE r, g, b PACKED ;
} RGB;

/* for ONLY-ONE */
typedef struct
{
	char name[13];
	long len;
} ONLYONE_FILE_ID;

/* for font */
typedef struct
{
	BYTE char_w, char_h;
	GFXBLK char_pic[FONT_CHARS];
} FONT;

#endif /* defined __dn_types_h */