/* DN-Soundsystem using MikMod */

#ifndef __dn_sound_h
  #define __dn_sound_h

#include <mikmod.h>

/* global vars */
extern UNIMOD *mymod;
extern BOOLEAN mod_play;

/* prototypes */
extern BOOLEAN init_mod(char *fname, BYTE device, BYTE channels_more);
extern BOOLEAN init_sample(char *fname, SAMPLE **s, BYTE device, BYTE channels);
extern void start_mod(BOOLEAN repeat, int volume, int fade);
extern void start_sample(SAMPLE *s, int channel);
extern void play_mod(int fading); /* this one to call in the mainloop */
extern void play_sound(void); /* or this */
extern BOOLEAN mod_ready(void);
extern void stop_sound(void);
extern void free_mod(void);
extern void free_sample(SAMPLE *s);
extern void exit_sound(void);
extern void SoundFading(int geschw);

#endif /* defined __dn_sound_h */