/* Headerfile for DN library functions */

#ifndef __dn_lib_h
  #define __dn_lib_h

#ifdef unix
	#ifndef MSDOS
#include <X11/Xlib.h>
	#endif /* not defined (MSDOS) */
#endif /* defined (unix) */

#include <dntypes.h>

/* variables */

/* from init */
extern char * error_text ;
extern void * screen_addr;
extern WORD gfxmode;
extern int screen_width, screen_height;
extern WORD clip_x1, clip_y1, clip_x2, clip_y2;
extern RGB alt_rgb[256] ;
extern BYTE rainbow_c1, rainbow_c2;
extern int sintab[360 + 90 + 1];
extern FONT schrift;
extern long screen_len;

/* from funcs */
extern WORD mouse_x, mouse_y;
extern BYTE mouse_k;
extern GFXBLK mousepic;
extern WORD mouse_hotx, mouse_hoty;

/* from key */
extern BYTE keytable[128];
BOOLEAN keyTest(int key) ;

/* from joystick */
extern BOOLEAN joystick;

/* from unix */
extern Display * jxdisp ;
extern int jxscreen ;
extern Window jxwin ;
extern GC jxgc ;

/* functions from init */
extern BOOLEAN init_gfx(WORD mode);
extern BOOLEAN set_mode(WORD mode);
extern void exit_gfx(void);
extern long timer(void);

/* funcs from joystick */
extern BOOLEAN init_joy1(void);
extern BOOLEAN joy1_b1(void);
extern BOOLEAN joy1_b2(void);
extern int joy1_x(void);
extern int joy1_y(void);
extern BOOLEAN joy1_up(void);
extern BOOLEAN joy1_right(void);
extern BOOLEAN joy1_down(void);
extern BOOLEAN joy1_left(void);

/* functions from palette */
extern void SetPalette(RGB *pal);
extern void GetPalette(RGB *pal);
extern void ClearPalette(RGB *pal);
extern void PaletteFadeIn(RGB *pal);
extern void PaletteFadeOut(RGB *pal);
extern void sort_palette(RGB *pal, RGB *pal2);
extern void pal_set_colour(BYTE col, BYTE red, BYTE green, BYTE blue) ;

/* functions from draw */
extern void PutPixel(WORD x, WORD y, BYTE color);
extern BYTE GetPixel(WORD x, WORD y);
extern void line(WORD x1, WORD y1, WORD x2, WORD y2, BYTE color, BOOLEAN rainbow);
extern void box(WORD x1, WORD y1, WORD x2, WORD y2, BYTE c, BOOLEAN fill, BOOLEAN rainbow);
extern void flood_fill(WORD x, WORD y, BYTE c, BOOLEAN rainbow);
extern void ellipse_circle(BOOLEAN circle, WORD x, WORD y, WORD r1, WORD r2, BYTE c, BOOLEAN fill, BOOLEAN rainbow);

/* functions from put */
extern void get(WORD x1, WORD y1, WORD x2, WORD y2, GFXBLK *blk);
extern void oldget(WORD x1, WORD y1, WORD x2, WORD y2, OLDBLK *blk);
extern void put(WORD x, WORD y, GFXBLK *blk);
extern void objput(WORD x, WORD y, GFXBLK *blk);
extern void addput(WORD x, WORD y, GFXBLK *blk);
extern void objzoom(WORD x, WORD y, WORD br, WORD h, GFXBLK *blk);
extern void objrotate(WORD x, WORD y, GFXBLK *obj, int rot);
extern void oldput(WORD x, WORD y, OLDBLK *blk);
extern void oldobjput(WORD x, WORD y, OLDBLK *blk);
extern void oldaddput(WORD x, WORD y, OLDBLK *blk);
extern void oldzoom(WORD x, WORD y, WORD br, WORD h, OLDBLK *blk);
extern void oldrotate(WORD x, WORD y, OLDBLK *obj, int rot);
extern void getvollbild(void *pic);
extern void putvollbild(void *pic);
extern void free_blk(GFXBLK * blk) ;

/* functions from pix */
extern BOOLEAN load_pic(char *dname, void *addr, RGB *pal);
extern void save_pic(char *fname, void *addr, RGB *pal);

/* from funcs */
extern void swap(WORD *a, WORD *b);
extern void wait(long time);
extern void cursor_off(void);
extern void cursor_on(void);
extern void init_mouse(void);
extern void mouse(void);
extern void set_mouse(WORD x, WORD y);
extern BOOLEAN alt_pressed(void);
extern void put_mouse(void);
extern BOOLEAN joy1_b1(void);
extern BOOLEAN joy1_b2(void);
extern int joy1_x(void);
extern int joy1_y(void);

/* from fsel */
void cut_ending(char *path, char *ending);
char *get_fname(const char *path);
void cut_filename(char *fname);
char *GetDrives(char *drvstr);
char GetCurDrive(void);
BOOLEAN TestDrive(char drive);
BOOLEAN FileSelect(const char *titel, char *path, char *name);

/* from font */
extern BOOLEAN load_font(const char *fname, WORD start_y, char start_ch, WORD char_w, WORD char_h, FONT *fnt);
extern void put_text(FONT *fnt, WORD x, WORD y, const unsigned char *txt);
extern void show_text(FONT *fnt, WORD x, WORD y, const unsigned char *txt);
extern char *get_text(FONT *fnt, WORD x, WORD y, char *txt);

/* from assembly */
extern void wait_retrace(void);
extern void Copy2Screen(void);
extern void copy_frame_buffer(void) ;
extern void cls(BYTE color);

/* from pack */
extern DWORD pack_pic(void * source, void * dest, DWORD len) ;
extern void unpack_pic(void * source, void * dest, DWORD len) ;

/* from rle */
extern void rle_get(int x1, int y1, int x2, int y2, RLEBLK * dest) ;
extern void rle_put(int x, int y, RLEBLK * src) ;

/* from system specific files */

#ifdef unix
  #ifndef MSDOS

extern void SetColors(RGB * pal, int start, int anz) ;
extern void delay(int msecs) ;
extern char * itoa(int value, char * buffer, int radix) ;
extern char * strupr(char * src) ;
extern char * strlwr(char * src) ;
extern XDestroyImage(XImage * image) ;

  #endif /* not defined (MSDOS) */
#endif /* defined (unix) */

extern char get_key(void) ;
extern void FindFile(const char * path, char * fname) ;
extern void do_events(void) ;
extern void set_caption(char * s) ;
extern void do_keyboard(long until) ;

/* from endian.c */
extern inline void _little_to_word(UWORD * w_in) ;
extern inline void _big_to_word(UWORD * w_in) ;
extern inline void _pdp_to_word(UWORD * w_in) ;
extern inline void _word_to_little(UWORD * w_in) ;
extern inline void _word_to_big(UWORD * w_in) ;
extern inline void _word_to_pdp(UWORD * w_in) ;
extern inline void _little_to_dword(UDWORD * d_in) ;
extern inline void _big_to_dword(UDWORD * d_in) ;
extern inline void _pdp_to_dword(UDWORD * d_in) ;
extern inline void _dword_to_little(UDWORD * d_in) ;
extern inline void _dword_to_big(UDWORD * d_in) ;
extern inline void _dword_to_pdp(UDWORD * d_in) ;

#endif /* defined __dn_lib_h */
