/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/****************************************\
* DN PC/DOS functions which do not exist *
*  in Unix                               *
* Copyright 1996 Michael Thayer          *
* For the Linux port of the DN libs      *
\****************************************/

#include <stdlib.h>
#include <dn.h>

/*
char * itoa(int value, char * buffer, int radix)
{
    int rem, sign, length ;
    const char numchars[16] =
      {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
      'A', 'B', 'C', 'D', 'E', 'F'} ;
    
    length = 0 ;
    rem = value ;
    while (rem > 0)
      {
        rem /= radix ;
        ++length ;
      }
    sign = 0 ;
    if (value < 0)
      {
        sign = 1 ;
        value = 0 - value ;
        ++length ;
      }
    if (value == 0)
      {
        buffer[0] = '0' ;
        buffer[1] = 0 ;
      }
    else
      {
        buffer[length] = 0 ;
        --length ;
      }

    while (value > 0)
      {
        rem = value % radix ;
        value /= radix ;
        if ((-1 < rem) && (rem < 16))
          {
            * (buffer + length) = numchars[rem] ;
          }
        else
          {
            * (buffer + length) = '*' ;
          }
        --length ;
      }
    if (sign)
      {
        buffer[0] = '-' ;
      }
    return(buffer) ;
} ;
*/

char * strupr(char * src)
{
    int r = 0 ;
    while (src[r] != 0)
      {
        if ( (src[r] <= 'z') && (src[r] >= 'a'))
          {
            src[r] += ('A' - 'a') ;
          }
        r++ ;
      }
    return(src) ;
}

char * strlwr(char * src)
{
    int r = 0 ;
    while (src[r] != 0)
      {
        if ( (src[r] <= 'Z') && (src[r] >= 'A'))
          {
            src[r] += ('a' - 'A') ;
          }
        r++ ;
      }
    return(src) ;
}
