/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/******************************/
/* New-OnlyOne (C) Juli 1996  */
/* by Michael Haar            */
/* modified by Michael Thayer */
/******************************/

/* TODO : duplicate oo_file[i] rather than reopening the file */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <dn.h>

/* globale Variablen */

int file_gefunden ;

long filestartpos, filelength;
FILE * oo_file[3] ;
int oo_entries[3] = {0, 0, 0} ;
ONLYONE_ENTRY * oo_dir[3] ;
int is_open = 0 ;

int open_fs(void)
{
  int i, j, k ;
  ONLYONEHEADER head ;

  oo_file[0] = fopen("video.one", "rb") ;
  oo_file[1] = fopen("audio.one", "rb") ;
  oo_file[2] = fopen("data.one", "rb") ;
  for (i = 0 ; i < 3 ; i++) {
      if (oo_file[i]) {
          if (fread(& head, sizeof(ONLYONEHEADER), 1, oo_file[i]) == 1) {
              if ( (head.id[0] == 'O') && (head.id[1] == 'O')) {
                  oo_dir[i] = malloc(head.entries * sizeof(ONLYONE_ENTRY)) ;
                  if (oo_dir[i]) {
                      if (fread(oo_dir[i], sizeof(ONLYONE_ENTRY), head.entries,
                        oo_file[i]) == head.entries) {
                          oo_entries[i] = head.entries ;
                          is_open = 1 ;
                      }
                  }
              }
          }
      }
  }
  for (i = 0 ; i < 3 ; i++) fclose(oo_file[i]) ;
  return(1) ;
}

/* Funktionsprototypen */
FILE *open_file(const char *fname);

long int filesize(FILE *fp);

/* Funktionen */
/* Suchen in der ONLY.ONE */
FILE *onlyone_find(const char *fname)
{
  FILE *datei = NULL ;
  int i, j ;

  if (!is_open)
    {
      if (!open_fs())
        {
          return(NULL) ;
        }
    }

  file_gefunden = 0 ;
  for (i = 0 ; i < 3 ; i++)
    {
      for (j = 0 ; j < oo_entries[i] ; j++)
        {
          if (!strcasecmp(oo_dir[i][j].filename, fname))
            {
              file_gefunden = 1 ;
              break ;
            }
        }
      if (file_gefunden)
        {
          break ;
        }
    }
  if (!file_gefunden)
    {
      filestartpos = 0 ;
      filelength = 0 ;
      return(NULL) ;
    }
  switch (i)
    {
      case 0: datei = fopen("video.one", "rb") ;
        break ;
      case 1: datei = fopen("audio.one", "rb") ;
        break ;
      case 2: datei = fopen("data.one", "rb") ;
    }
  if (!datei)
    {
      filestartpos = 0 ;
      filelength = 0 ;
      return(NULL) ;
    }
  filestartpos = oo_dir[i][j].startpos ;
  filelength = oo_dir[i][j].length ;
  fseek(datei, filestartpos, SEEK_SET) ;
  return(datei) ;
}

long int filesize(FILE *fp)
{
	long int save_pos, size_of_file;

	save_pos = ftell(fp);
	fseek( fp, 0L, SEEK_END );
	size_of_file = ftell(fp);
	fseek(fp, save_pos, SEEK_SET);

	return(size_of_file);
}

/* Normales Suchen */
FILE *normal_find(const char *fname)
{
	FILE *datei;
	char filename[1024];

	strcpy(filename, fname);
	file_gefunden = 0;
	FindFile(".", filename);
	/* Normale Datei oeffnen */
	datei = fopen(filename, "rb");
	if(datei)
	{
		filestartpos = 0;
		filelength = filesize(datei);
		return(datei);
	}

	filestartpos = 0;
	filelength = 0;
	return(NULL);
}

FILE *open_file(const char *fname)
{
	FILE *datei;

	/* Suchen nach der gesuchten Datei */
	datei = onlyone_find(fname);
	if(!datei)
		return(normal_find(fname));		/* Ansonsten andere Datei suchen */

	return(datei);
}
