Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. No modifications intended to allow the software to be used within the
   Ms-Dos and Windows operating systems may be distributed with, or
   applied to, the source code or binary form of the software.
6. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
7. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include <stdlib.h>
#include <dn.h>

union _d_end
{
    struct
      {
        UBYTE b1 PACKED ;
        UBYTE b2 PACKED ;
        UBYTE b3 PACKED ;
        UBYTE b4 PACKED ;
      } b ;
    UDWORD d ;
} ;

union _w_end
{
    struct
      {
        UBYTE b1 PACKED ;
        UBYTE b2 PACKED ;
      } b ;
    UWORD w ;
} ;

#define _w_in ( (union _w_end) ( * w_in) )
#define _d_in ( (union _d_end) ( * d_in) )

inline void _little_to_word(UWORD * w_in)
{
    UWORD w ;
    
    w = _w_in.b.b2 * 0x100 + _w_in.b.b1 ;
    * w_in = w ;
}

inline void _big_to_word(UWORD * w_in)
{
    UWORD w ;
    
    w = _w_in.b.b1 * 0x100 + _w_in.b.b2 ;
    * w_in = w ;
}

inline void _pdp_to_word(UWORD * w_in)
{
    UWORD w ;
    
    w = _w_in.b.b2 * 0x100 + _w_in.b.b1 ;
    * w_in = w ;
}

inline void _word_to_little(UWORD * w_in)
{
    union _w_end w ;
    
    w.b.b2 = ( * w_in) / 0x100 ;
    w.b.b1 = ( * w_in) % 0x100 ;
    * w_in = w.w ;
}

inline void _word_to_big(UWORD * w_in)
{
    union _w_end w ;
    
    w.b.b1 = ( * w_in) / 0x100 ;
    w.b.b2 = ( * w_in) % 0x100 ;
    * w_in = w.w ;
}

inline void _word_to_pdp(UWORD * w_in)
{
    union _w_end w ;
    
    w.b.b2 = ( * w_in) / 0x100 ;
    w.b.b1 = ( * w_in) % 0x100 ;
    * w_in = w.w ;
}

inline void _little_to_dword(UDWORD * d_in)
{
    UDWORD d ;
    
    d = _d_in.b.b1 + (_d_in.b.b2 * 0x100)
        + (_d_in.b.b3 * 0x10000) + (_d_in.b.b4 * 0x1000000) ;
    * d_in = d ;
}

inline void _big_to_dword(UDWORD * d_in)
{
    UDWORD d ;
    
    d = _d_in.b.b4 + (_d_in.b.b3 * 0x100)
        + (_d_in.b.b2 * 0x10000) + (_d_in.b.b1 * 0x1000000) ;
    * d_in = d ;
}

inline void _pdp_to_dword(UDWORD * d_in)
{
    UDWORD d ;
    
    d = _d_in.b.b3 + (_d_in.b.b4 * 0x100)
        + (_d_in.b.b1 * 0x10000) + (_d_in.b.b2 * 0x1000000) ;
    * d_in = d ;
}

inline void _dword_to_little(UDWORD * d_in)
{
    union _d_end d ;
    
    d.b.b1 = ( * d_in) % 0x100 ;
    d.b.b2 = ( ( * d_in) / 0x100 ) % 0x100 ;
    d.b.b3 = ( ( * d_in) / 0x10000 ) % 0x100 ;
    d.b.b4 = ( * d_in) / 0x1000000 ;
    * d_in = d.d ;
}

inline void _dword_to_big(UDWORD * d_in)
{
    union _d_end d ;
    
    d.b.b4 = ( * d_in) % 0x100 ;
    d.b.b3 = ( ( * d_in) / 0x100 ) % 0x100 ;
    d.b.b2 = ( ( * d_in) / 0x10000 ) % 0x100 ;
    d.b.b1 = ( * d_in) / 0x1000000 ;
    * d_in = d.d ;
}

inline void _dword_to_pdp(UDWORD * d_in)
{
    union _d_end d ;
    
    d.b.b3 = ( * d_in) % 0x100 ;
    d.b.b4 = ( ( * d_in) / 0x100 ) % 0x100 ;
    d.b.b1 = ( ( * d_in) / 0x10000 ) % 0x100 ;
    d.b.b2 = ( * d_in) / 0x1000000 ;
    * d_in = d.d ;
}

