/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**************************************/
/* DN-GFX-Fileselector                */
/* (C) Mar 1996 by Michael Haar       */
/**************************************/

#ifndef MSDOS
  #error These functions (dos_fsel.c) only exist for DOS at present
#endif

#include <conio.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <dos.h>
#include <dn.h>

/* global vars */
#define BOX_X 27
#define BOX_Y 4
#define PATH_Y 3
#define NAME_Y (PATH_Y + 1)
#define FILES_Y (NAME_Y + 2)
#define INFO_Y (FILES_Y + 11)
#define OK_X 25
#define OK_Y INFO_Y;

typedef struct
{
	BYTE attr;
	char name[13];
	void *next;
} FSELFILE;
int sel_pos, anz_pos, show_anz;
enum { Auswahl, OK, Nameneingabe } fsel_mode;

/* WARNING : THIS WAS "PUTTEXT", REPLACED THROUGHOUT FILE TO AVOID CONFLICT */
char textput[80], s[128];
/* END WARNING */

void *fselpic;
GFXBLK boxpic;

extern void *screen_addr;
extern WORD screen_width, screen_height;
extern WORD clip_x1, clip_y1, clip_x2, clip_y2;
extern RGB alt_rgb[256];
extern FONT schrift;
extern WORD mouse_x, mouse_y;
extern BYTE mouse_k;

/* prototypes */
void cut_ending(char *path, char *ending);
char *get_fname(const char *path);
void cut_filename(char *fname);
char *GetDrives(char *drvstr);
char GetCurDrive(void);
BOOLEAN TestDrive(char drive);
BOOLEAN FileSelect(const char *titel, char *path, char *name);

extern void SetPalette(RGB *pal);
extern void box(WORD x1, WORD y1, WORD x2, WORD y2, BYTE c, BOOLEAN fill, BOOLEAN rainbow);
extern void getvollbild(void *pic);
extern void putvollbild(void *pic);
extern void get(WORD x1, WORD y1, WORD x2, WORD y2, GFXBLK *blk);
extern void put(WORD x, WORD y, GFXBLK *blk);
extern BOOLEAN load_pic(const char *dname, void *addr, RGB *pal);
extern void cursor_off(void);
extern void cursor_on(void);
extern void mouse(void);
extern void put_mouse(void);
extern void put_text(FONT *fnt, WORD x, WORD y, const char *txt);
extern void show_text(FONT *fnt, WORD x, WORD y, const char *txt);
extern void Copy2Screen(void);

/* functions */
/*************************************** Filename, ... ***********************************/
/* cuts the ending in a path off */
void cut_ending(char *path, char *ending)
{
	char *pos;

	pos = strrchr(path, '\\');
	strcpy(ending, pos + 1);
	*pos = 0;
}

/* finds the filename */
char *get_fname(const char *path)
{
	return(strrchr(path, '\\') + 1);
}

/* cuts the ending/filename off */
void cut_filename(char *fname)
{
	*(char *)(get_fname(fname) - 1) = 0;
}

char *GetDrives(char *drvstr)
{
/*      char test;
	char dir[5];
	char alt[1024]; */

	strcpy(drvstr, "ABCD");
/*      getcwd(alt, 1024);

	for(test = 'C'; test < 'Z'; test++)
	{
		strcpy(dir, " :\\");
		dir[0] = test;
		if(chdir(dir) == 0)
		{
			drvstr[strlen(drvstr) + 1] = 0;
			drvstr[strlen(drvstr)] = test;
		}
	}
	chdir(alt); */

	return(drvstr);
}

char GetCurDrive(void)
{
	unsigned test;

	_dos_getdrive(&test);
	return('A' + (char)test - 1);
}

BOOLEAN TestDrive(char drive)
{
/*      char alt[1024], test[20];
	BOOLEAN erg;

	getcwd(alt, 1024);
	test[0] = drive;
	test[1] = 0;
	strcat(test, ":\\");
	erg = (chdir(test) == 0);
	chdir(alt);

	return(erg); */
	return(TRUE);
}

/* Anzahl der Eintraege in einer Liste: */
int AnzEintraege(FSELFILE *list)
{
	int a;

	a = 0;
	while(list != NULL)
	{
		list = list->next;
		a++;
	}
	return(a);
}

/* Anzahl der Dateien in einer Liste: */
int AnzFiles(FSELFILE *list)
{
	int a;

	a = 0;
	while(list != NULL)
	{
		if((list->attr & _A_NORMAL) || (list->attr & _A_RDONLY) || (list->attr & _A_ARCH))
			a++;
		list = list->next;
	}
	return(a);
}

/* Hier alles fuer Textmode: */
void WriteMarked(const char *text)
{
	/* TextBackground(LightGray);
	TextColor(Black); */
	printf("%s", text);
	/* TextColor(LightGray);
	TextBackground(Black); */
}

void ShowTitle(const char *titel)
{
	if(screen_width == 80)
	{
		/* GotoXY(BOX_X, BOX_Y); */
		printf("ͻ");
		/* GotoXY(BOX_X, BOX_Y + 1); */
		printf("                           ");
		/* GotoXY(BOX_X, BOX_Y + 2); */
		printf("͹");
		/* GotoXY(BOX_X + 2, BOX_Y + 1); */
		printf("%s", titel);
	 }
	else
		show_text(&schrift, 86, 22, titel);
}

void ShowPath(const char *path)
{
	int maxlen;

	maxlen = (6 * 24) / schrift.char_w;

	strcpy(textput, path);
	if(strlen(path) >= maxlen)
	{
		strncpy(textput, &path[strlen(path) - maxlen], maxlen);
		textput[maxlen] = 0;
	}
	else
	{
		memset(&textput[strlen(textput)], ' ', maxlen - strlen(textput));
		textput[maxlen] = 0;
	}

	if(screen_width == 80)
	{
		/* GotoXY(BOX_X, BOX_Y + PATH_Y); */
		/* Write('                           '); */
		/* GotoXY(BOX_X + 2, BOX_Y + PATH_Y); */
		printf("%s", textput);
		/* GotoXY(BOX_X, BOX_Y + PATH_Y + 1); */
	}
	else
		show_text(&schrift, 86, 37, textput);
}

void ShowFName(const char *name)
{
	int maxlen;

	maxlen = (6 * 24) / schrift.char_w;

	strcpy(textput, name);
	memset(&textput[strlen(textput)], ' ', maxlen - strlen(textput));
	textput[maxlen] = 0;
	if(screen_width == 80)
	{
		/* GotoXY(BOX_X, BOX_Y + NAME_Y); */
		printf("                           ");
		/* GotoXY(BOX_X + 2, BOX_Y + NAME_Y); */
		if(fsel_mode == Nameneingabe)
			WriteMarked(textput);
		else
			printf("%s", textput);
		/* GotoXY(BOX_X, BOX_Y + NAME_Y + 1); */
		printf("͹");
	}
	else if(fsel_mode == Nameneingabe)
	{
		box(86, 45, 232, 52, 15, TRUE, FALSE);
		put_text(&schrift, 86, 45, textput);
	}
	else
		show_text(&schrift, 86, 45, textput);
}

void ShowFiles(int sel_pos, FSELFILE *fsel_file)
{
	int i, t;

	if(screen_width == 80)
	{
		/* GotoXY(BOX_X, BOX_Y + FILES_Y); */
		printf("                         ");
		for(i = 1; i <= show_anz - 2; i++)
		{
			/* GotoXY(BOX_X, BOX_Y + FILES_Y + i); */
			if(i == sel_pos * (show_anz - 2) / AnzEintraege(fsel_file) + 1)
				printf("                         ۺ");
			else
				printf("                         ");
		}
		/* GotoXY(BOX_X, BOX_Y + FILES_Y + show_anz - 1); */
		printf("                         ");
	}

	i = 0;
	while(i < anz_pos)
	{
		fsel_file = fsel_file->next;
		i++;
	}
	while(i < show_anz + anz_pos)
	{
		if(screen_width == 80)
			/* GotoXY(BOX_X + 1, BOX_Y + FILES_Y + (i - anz_pos)) */;
		if(fsel_file != NULL)
		{
			if(((fsel_file->attr & _A_SUBDIR) > 0) || (fsel_file->attr == 0))
			{
				if(screen_width == 80)
					printf(">");
				else
					show_text(&schrift, 86, 60 + 8 * (i - anz_pos), "-");
			}
			else
			{
				if(screen_width == 80)
					printf(" ");
			}
			if((fsel_mode == Auswahl) && (i == sel_pos))
			{
				strcpy(textput, fsel_file->name);
				for(t = 0; t <= 13 - strlen(fsel_file->name); t++)
					strcat(textput, " ");
				if(screen_width == 80)
					WriteMarked(textput);
				else
				{
					box(92, 60 + 8 * (i - anz_pos), 215, 67 + 8 * (i - anz_pos), 15, TRUE, FALSE);
					put_text(&schrift, 92, 60 + 8 * (i - anz_pos), textput);
				}
			}
			else
			{
				strcpy(textput, fsel_file->name);
				for(t = 0; t <= 13 - strlen(fsel_file->name); t++)
					strcat(textput, " ");
				if(screen_width == 80)
					printf("%s", textput);
				else
					show_text(&schrift, 92, 60 + 8 * (i - anz_pos), textput);
			}
			fsel_file = fsel_file->next; /* und das naechste ... */
		}
		else if(screen_width == 80)
			printf("              ");
		i++;
	}
	if(screen_width == 80)
	{
		/* GotoXY(BOX_X, BOX_Y + FILES_Y + show_anz); */
		printf("͹");
	}
}


/* Anzeigen der Box: */
void ShowFSelBox(const char *titel, const char *path, const char *name, FSELFILE *fsel_file)
{
	if(screen_width == 80)
	{
		ShowTitle(titel);
		ShowPath(path);
		ShowFName(name);
		ShowFiles(sel_pos, fsel_file);
		/* ShowInfo */
		/* GotoXY(BOX_X, BOX_Y + INFO_Y); */
		printf("                           ");
		/* GotoXY(BOX_X + 2, BOX_Y + INFO_Y); */
		printf("%d Files", AnzFiles(fsel_file));
		/* GotoXY(BOX_X + OK_X, BOX_Y + OK_Y); */
		if(fsel_mode == OK)
			WriteMarked("OK");
		else
			printf("OK");
		/* GotoXY(BOX_X, BOX_Y + INFO_Y + 1); */
		printf("ͼ");
		/* Zur Namenseingabe: */
		if(fsel_mode == Nameneingabe)
		{
			/* GotoXY(BOX_X + 2 + Length(name), BOX_Y + NAME_Y); */
			cursor_on();
		}
		else
			cursor_off();
	}
	else
	{
		put(clip_x1, clip_y1, &boxpic);
		ShowTitle(titel);
		ShowPath(path);
		ShowFName(name);
		itoa(AnzFiles(fsel_file), s, 10);
		ShowFiles(sel_pos, fsel_file);
		show_text(&schrift, 86, 169, s);
		show_text(&schrift, 86 + 4 * 6, 169, " FILES");
		getvollbild(fselpic);
		put_mouse();
		Copy2Screen();
	}
}

/* Loeschen der Liste: */
void FreeFilelist(FSELFILE *list)
{
	FSELFILE *alt;

	while(list != NULL)
	{
		alt = list;
		list = list->next;
		free(alt);
	}
}

int SearchFilelist(char *find, FSELFILE *list)
{
	int file_pos;
	int erg;

	erg = -1;
	file_pos = 0;
	while(list != NULL)
	{
		if(!strcmp(list->name, find) && (((list->attr & _A_NORMAL) > 0) || ((list->attr & _A_RDONLY) > 0)))
			erg = file_pos;
		list = list->next;
		file_pos++;
	}

	return(erg);
}

BOOLEAN FSelKleiner(FSELFILE a, FSELFILE b)
{
	if(a.attr == 0)
		return(FALSE);
	else if(b.attr == 0)
		return(TRUE);
	else if(!strcmp(a.name, ".."))
		return(FALSE);
	else if(!strcmp(b.name, ".."))
		return(TRUE);
	else if(((a.attr & _A_ARCH) > 0) || ((a.attr & _A_RDONLY) > 0))
	{
		if((b.attr & _A_SUBDIR) > 0)
			return(FALSE);
		else if(strcmp(a.name, b.name) < 0)
			return(TRUE);
		else
			return(FALSE);
	}
	else
	{
		if(((b.attr & _A_ARCH) > 0) || ((b.attr & _A_RDONLY) > 0))
			return(TRUE);
		else if(strcmp(a.name, b.name) < 0)
			return(TRUE);
		else
			return(FALSE);
	}
}

void SortFilelist(FSELFILE *list)
{
	FSELFILE *p1, *p2;
	FSELFILE swap;

	p1 = list;
	while(p1->next != NULL)
	{
		p1 = p1->next; /* nicht mit sich selber sortieren! */
		p2 = list;
		while(p2 != NULL)
		{
			if(FSelKleiner(*p1, *p2))
			{
				strcpy(swap.name, p1->name);
				swap.attr = p1->attr;
				strcpy(p1->name, p2->name);
				p1->attr = p2->attr;
				strcpy(p2->name, swap.name);
				p2->attr = swap.attr;
			}
			p2 = p2->next;
		}
	}
}

/* Anlegen einer Liste aller gesuchten Dateien im aktuellen Verzeichnis: */

#ifdef __WATCOMC__
void GetFiles(const char *path, const char *name, FSELFILE **list)
#else if defined (DJGPP)
void GetFiles(char *path, const char *name, FSELFILE **list)
/* DJGPP doesn't like discarding the 'const' in call to _dos_findfirst */
#endif

{
	int i;
	struct find_t files;
	FSELFILE *newlist;
	char search[1024];

	/* Alte Liste loeschen: */
	FreeFilelist(*list);
	newlist = NULL;
	*list = NULL;
	/* Zuerst die Ordner: */
	/* fuer WIN95 auch '*' (fuer '*.*') suchen: */
	strcpy(search, path);
	*strrchr(search, '.') = 0; /* \\* */
	if(!_dos_findfirst(search, _A_SUBDIR + _A_RDONLY, &files))
	{
		do
		{
			if(strcmp(files.name, "."))
			{
				if(newlist == NULL)
				{
					newlist = malloc(sizeof(FSELFILE));
					if(*list == NULL)
						*list = newlist;
				}
				else
				{
					newlist->next = malloc(sizeof(FSELFILE));
					newlist = newlist->next;
				}
				strcpy(newlist->name, files.name);
				newlist->attr = files.attrib;
				newlist->next = NULL;
			}
		}
		while(!_dos_findnext(&files));
	}

#ifdef __WATCOMC__
	_dos_findclose(&files);
#endif

	/* Restliche Ordner: */
	strcat(search, ".*");

	if(!_dos_findfirst(search, _A_SUBDIR, &files))
	{
		do
		{
			if(strcmp(files.name, "."))
			{
				/* Gibt es diesen Eintrag schon? */
				if(SearchFilelist(files.name, newlist) > -1)
				{
					if(newlist == NULL)
					{
						newlist = malloc(sizeof(FSELFILE));
						if(*list == NULL)
							*list = newlist;
					}
					else
					{
						newlist->next = malloc(sizeof(FSELFILE));
						newlist = newlist->next;
					}
					strcpy(newlist->name, files.name);
					newlist->attr = files.attrib;
					newlist->next = NULL;
				}
			}
		}
		while(!_dos_findnext(& files));
	}

#ifdef __WATCOMC__
	_dos_findclose(&files);
#endif

	/* Dann die Dateien: */
	if(!_dos_findfirst(path, _A_NORMAL, &files))
	{
		do
		{
			if(newlist == NULL)
			{
				newlist = malloc(sizeof(FSELFILE));
				if(*list == NULL)
					*list = newlist;
			}
			else
			{
				newlist->next = malloc(sizeof(FSELFILE));
				newlist = newlist->next;
			}
			strcpy(newlist->name, files.name);
			newlist->attr = files.attrib;
			newlist->next = NULL;
		}
		while(!_dos_findnext(&files));
	}

#ifdef __WATCOMC__
	_dos_findclose(&files);
#endif

	/* Laufwerke: */
	GetDrives(search);
	for(i = 0; i < strlen(search); i++)
		if(search[i] != path[0])
		{
			newlist->next = malloc(sizeof(FSELFILE));
			newlist = newlist->next;
			newlist->name[0] = search[i];
			newlist->name[1] = ':';
			newlist->name[2] = 0;
			newlist->attr = 0;
			newlist->next = NULL;
		}
	SortFilelist(*list);
}

/* Pfad um eine Ebene zuruecksetzen: */
void PathBack(char *path)
{
	char *str_pos;
	char endung[5];

	cut_ending(path, endung);
	if(endung[0] != 0)
	{
		/* Letzes Verzeichnis entfernen: */
		str_pos = strrchr(path, '\\');
		if(str_pos)
			*str_pos = 0;
		strcat(path, "\\");
		strcat(path, endung);
	}
}

/* Pfad um eine Ebene tiefersetzen: */
void NewPath(char *path, const char *to_dir)
{
	char endung[5];

	cut_ending(path, endung);
	strcat(path, "\\");
	strcat(path, to_dir);
	strcat(path, "\\");
	strcat(path, endung);
}

/* Bei Auswahl evtl. einen Ordner angewaehlt (oder andere Datei): */
void Selected(char *path, char *name, int *pos, FSELFILE **list)
{
	int i;
	FSELFILE *newlist;

	/* start of Selected */
	newlist = *list;
	i = 0;
	while(i < *pos)
	{
		newlist = newlist->next;
		i++;
	}
	/* Was wurde angewaehlt: */
	if(!strcmp(newlist->name, ".."))
	{
		if(!TestDrive(path[0]))
			putch(7);
		else
		{
			anz_pos = 0;
			*pos = 0;
			strcpy(name, "");
			PathBack(path);
			GetFiles(path, name, list);
		}
	}
	else if((newlist->attr == 0))
	{
		/* Laufwerkswechsel: */
		if(!TestDrive(newlist->name[0]))
			putch(7);
		else
		{
			anz_pos = 0;
			*pos = 0;
			cut_ending(path, s);
			path[0] = newlist->name[0];
			path[1] = ':';
			path[2] = '\\';
			path[3] = 0;
			strcat(path, s);
			strcpy(name, "");
			GetFiles(path, name, list);
		}
	}
	else if((newlist->attr & _A_SUBDIR) > 0)
	{
		if(!TestDrive(path[0]))
			printf("\7");
		else
		{
			anz_pos = 0;
			*pos = 0;
			strcpy(name, "");
			NewPath(path, newlist->name);
			GetFiles(path, name, list);
		}
	}
	else
		strcpy(name, newlist->name);
}
	
/************************************* FILESELECT ****************************************/
BOOLEAN FileSelect(const char *titel, char *path, char *name)
{
	BOOLEAN ende, erg;
/* MODIFIED */
	unsigned char ch[2];
/* END */
	FSELFILE *filelist;
	int i;
	char str[1024];
	int alt_pos;

	/* FSELfunktion: */
	anz_pos = 0;
	sel_pos = 0;
	fsel_mode = Auswahl;
	ende = FALSE;
	path = strupr(path);
	name = strupr(name);
	filelist = NULL;

	if(screen_width == 80)
	{
		cursor_off();
		show_anz = 10;
	}
	else
	{
		show_anz = 13;
		fselpic = malloc(screen_height * screen_width);
		load_pic("FSELECT.PIX", screen_addr, alt_rgb);
		get(clip_x1, clip_y1, clip_x2, clip_y2, &boxpic);
		SetPalette(alt_rgb);
	}

	GetFiles(path, name, &filelist);
	ShowFSelBox(titel, path, name, filelist);
	do
	{
		mouse();
		if(screen_width > 80)
		{
			putvollbild(fselpic);
			put_mouse();
			Copy2Screen();
		}

		ch[0] = 255;
		ch[1] = 255;
		if(mouse_k == 1)
		{
			if(screen_width == 80)
			{
				/* Koordinatenabfrage: */
				if((mouse_x >= 408) && (mouse_x <= 416) && (mouse_y == 160))
				{
					ch[0] = 13;     /* OK */
					/* Bei der Maus gibt es keinen Auswahlmodus: */
					if((fsel_mode == Auswahl) || (fsel_mode == Nameneingabe))
						fsel_mode = OK;
					while(mouse_k == 1)
						mouse();
				}
				else if((mouse_x >= 224) && (mouse_x <= 416) && (mouse_y == 56))
				{
					if(fsel_mode != Nameneingabe)
					{
						fsel_mode = Nameneingabe;
						ShowFSelBox(titel, path, name, filelist);
					}
					else if((name[0] != 0))
						ch[0] = 13;
					while(mouse_k == 1)
						mouse();
				}
				else if((mouse_x == 424) && (mouse_y == 72))
				{
					/* Hoch */
					ch[0] = 0;
					ch[1] = 'H';
					delay(100);
				}
				else if((mouse_x == 424) && (mouse_y == 144))
				{
					/* Runter */
					ch[0] = 0;
					ch[1] = 'P';
					delay(100);
				}
				else if((mouse_x == 424) && (mouse_y >= 80) && (mouse_y <= 136))
				{
					ch[0] = 0;
					/* PageUp-Down */
					if((mouse_y / 8 - FILES_Y - 3) < sel_pos * (show_anz - 2) / AnzEintraege(filelist) + 1)
						ch[1] = 'I';
					else if((mouse_y / 8 - FILES_Y - 3) > sel_pos * (show_anz - 2) / AnzEintraege(filelist) + 1)
						ch[1] = 'Q';
					delay(100);
				}
				else if((mouse_x >= 224) && (mouse_x <= 312) && (mouse_y >= 72) && (mouse_y <= 144))
				{
					/* File oder Ordner angewaehlt: */
					alt_pos = sel_pos; /* Zum Vergleichen fuer Doppelreturn sichern. */
					sel_pos = anz_pos + ((mouse_y / 8) - FILES_Y - 2) - 1;
					ch[0] = 13;
					while(mouse_k == 1)
						mouse();
				}
			}
			else
			{
				/* Koordinatenabfrage: */
				if((mouse_x >= 203) && (mouse_x <= 232) && (mouse_y >= 169) && (mouse_y <= 177))
				{
					ch[0] = 13;     /* OK */
					/* Bei der Maus gibt es keinen Auswahlmodus: */
					if((fsel_mode == Auswahl) || (fsel_mode == Nameneingabe))
						fsel_mode = OK;
					while(mouse_k == 1)
						mouse();
				}
				else if((mouse_x >= 86) && (mouse_x <= 232) && (mouse_y >= 44) && (mouse_y <= 52))
				{
					if(fsel_mode != Nameneingabe)
					{
						fsel_mode = Nameneingabe;
						ShowFSelBox(titel, path, name, filelist);
					}
					else if(name[0] != 0)
						ch[0] = 13;
					while(mouse_k == 1)
						mouse();
				}
				else if((mouse_x >= 223) && (mouse_x <= 232) && (mouse_y >= 60) && (mouse_y <= 69))
				{
					/* Hoch */
					ch[0] = 0;
					ch[1] = 'H';
					delay(100);
				}
				else if((mouse_x >= 223) && (mouse_x <= 232) && (mouse_y >= 153) && (mouse_y <= 162))
				{
					/* Runter */
					ch[0] = 0;
					ch[1] = 'P';
					delay(100);
				}
				else if((mouse_x >= 223) && (mouse_x <= 232) && (mouse_y >= 72) && (mouse_y <= 152))
				{
					ch[0] = 0;
					/* PageUp-Down */
					if((mouse_y - 60) / 8 < sel_pos * (show_anz - 2) / AnzEintraege(filelist) + 1)
						ch[1] = 'I';
					else if((mouse_y - 60) / 8 > sel_pos * (show_anz - 2) / AnzEintraege(filelist) + 1)
						ch[1] = 'Q';
					delay(100);
				}
				else if((mouse_x >= 86) && (mouse_x <= 215) && (mouse_y >= 60) && (mouse_y <= 163))
				{
					/* File oder Ordner angewaehlt: */
					alt_pos = sel_pos; /* Zum Vergleichen fuer Doppelreturn sichern. */
					sel_pos = anz_pos + (mouse_y - 60) / 8;
					ch[0] = 13;
					while(mouse_k == 1)
						mouse();
				}
			}
		}
		else if(mouse_k == 2)
		{
			ch[0] = 8; /* Backspace */
			while(mouse_k == 2)
				mouse();
		}
		else if(mouse_k == 3)
		{
			ch[0] = 27; /* Ende */
			while(mouse_k == 3)
				mouse();
		}

		if(kbhit())
		{
			ch[0] = getch();
			if(ch[0] == 0)
				ch[1] = getch();
		}

		if(ch[0] != 255)
		{
			switch(ch[0])
			{
				case 13:
					/* OK */
					if(fsel_mode == Auswahl)
					{
						strcpy(str, name);
						Selected(path, name, &sel_pos, &filelist);
						if((sel_pos == alt_pos) && !strcmp(str, name) && (name[0] != 0))
						{
							/* DoppelRETURN: */
							erg = TRUE;
							ende = TRUE;
						}
					}
					else if(fsel_mode == OK)
					{
						if(name[0] != 0)
						{
							erg = TRUE;
							ende = TRUE;
						}
						else
						{
							printf("\7");
							fsel_mode = Nameneingabe;
						}
					}
					else if(fsel_mode == Nameneingabe)
					{
						name = strupr(name);
						/* Ist es eine Endung? */
						if(strstr(name, "*.") != NULL)
						{
							cut_ending(path, s);
							strcat(path, "\\");
							strcat(path, name);
							strcpy(name, "");
							anz_pos = 0;
							sel_pos = 0;
							GetFiles(path, name, &filelist);
						}
						else
						{
							/* sonst neuer name: */
							/* existiert er? -> dann markieren und anwaehlen: */
							i = SearchFilelist(name, filelist);
							if(i > -1)
							{
								anz_pos = i;
								sel_pos = i;
							}
						}
						fsel_mode = Auswahl;
					}
					break;
				case 27:
					/* Cancel */
					erg = FALSE;
					ende = TRUE;
					break;
				case 8:
					/* Backspace: */
					if(fsel_mode == Auswahl)
					{
						if(!TestDrive(path[0]))
							printf("\7");
						else
						{
							anz_pos = 0;
							sel_pos = 0;
							strcpy(name, "");
							PathBack(path);
							GetFiles(path, name, &filelist);
						}
					}
					else if((fsel_mode == Nameneingabe) && (strlen(name) > 0))
					{
						/* BKSPC halt: */
						name[strlen(name) - 1] = 0;
					}
					break;
				case 9:
					/* TAB */
					if(fsel_mode == Auswahl)
						fsel_mode = OK;
					else if(fsel_mode == OK)
						fsel_mode = Nameneingabe;
					else if(fsel_mode == Nameneingabe)
					{
						fsel_mode = OK;
						name = strupr(name);
					}
				case 0:
					if(kbhit())
						ch[1] = getch();
					if(ch[1] != 255)
					{
						switch(ch[1])
						{
							case 'H':
								/* Hoch */
								if(fsel_mode == Auswahl)
									if(sel_pos > 0)
										sel_pos--;
									if(sel_pos < anz_pos)
										anz_pos--;
								break;
							case 'I':
								/* PageUp */
								if(fsel_mode == Auswahl)
								{
									if(sel_pos > show_anz - 1)
										sel_pos -= show_anz;
									else if(sel_pos > 0)
										sel_pos = 0;
									if(anz_pos > show_anz - 1)
										anz_pos -= show_anz;
									else if(anz_pos > 0)
										anz_pos = 0;
								}
								break;
							case 'P':
								/* Runter */
								if(fsel_mode == Auswahl)
								{
									if(sel_pos < AnzEintraege(filelist) - 1)
										sel_pos++;
									if(sel_pos > anz_pos + show_anz - 1)
										anz_pos++;
								}
								break;
							case 'Q':
								/* PageDown */
								if(fsel_mode == Auswahl)
								{
									if(sel_pos < AnzEintraege(filelist) - 1 - show_anz)
										sel_pos += show_anz;
									else if(sel_pos < AnzEintraege(filelist) - 1)
										sel_pos = AnzEintraege(filelist) - 1;
									if(anz_pos < AnzEintraege(filelist) - 1 - show_anz)
										anz_pos += show_anz;
									else if(anz_pos < AnzEintraege(filelist) - 1)
										anz_pos = AnzEintraege(filelist) - 1;
								}
								break;
							case 'K':
								/* links */
								if(fsel_mode == Auswahl)
									fsel_mode = Nameneingabe;
								else if(fsel_mode == Nameneingabe)
								{
									fsel_mode = OK;
									name = strupr(name);
								}
								else if(fsel_mode == OK)
									fsel_mode = Auswahl;
								break;
							case 'M':
								/* rechts */
								if(fsel_mode == Auswahl)
									fsel_mode = OK;
								else if(fsel_mode == OK)
									fsel_mode = Nameneingabe;
								else if(fsel_mode == Nameneingabe)
								{
									fsel_mode = OK;
									name = strupr(name);
								}
						}
					}
					break;
				default:
					if(fsel_mode == Nameneingabe)
					{
						ch[0] = toupper(ch[0]);
						if((ch[0] > ' '))
						{
							if((strlen(name) == 8) && !strchr(name, '.'))
								strcat(name, ".");
							if(strlen(name) < 12)
							{
								if(strchr(name, '.'))
								{
									if((strlen(name) < strchr(name, '.') - name + 4) && (ch[0] != '.'))
									{
										name[strlen(name) + 1] = 0;
										name[strlen(name)] = ch[0];
									}
								}
								else
								{
									name[strlen(name) + 1] = 0;
									name[strlen(name)] = ch[0];
								}
							}
						}
					}
			}
			ShowFSelBox(titel, path, name, filelist);
		}
	}
	while(!ende);

	strcpy(str, path);
	cut_ending(str, s);
	strcpy(s, name);
	strcpy(name, str);
	strcat(name, "\\");
	strcat(name, s);

	FreeFilelist(filelist);

	if(screen_width == 80)
	{
		cursor_on();
	}
	else
	{
		free(fselpic);
		free(boxpic.mem);
	}

	return(erg);
}
