/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/********************************/
/* DN-GFX-Func: Putfunctions    */
/* (C) Mar 1996 by Michael Haar */
/********************************/

#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <dn.h>

/* prototypes */
void oldget(WORD x1, WORD y1, WORD x2, WORD y2, OLDBLK *blk);
void oldput(WORD x, WORD y, OLDBLK *blk);
void oldobjput(WORD x, WORD y, OLDBLK *blk) ;
void oldaddput(WORD x, WORD y, OLDBLK *blk);
void oldzoom(WORD x, WORD y, WORD w, WORD h, OLDBLK *blk);
void oldrotate(WORD x, WORD y, OLDBLK * obj, int rot) ;
void getvollbild(void *pic);
void putvollbild(void *pic);

extern void swap(WORD *a, WORD *b);
extern void PutPixel(WORD x, WORD y, BYTE color);

/* functions */
void oldget(WORD x1, WORD y1, WORD x2, WORD y2, OLDBLK *blk)
{
	WORD y;
	void *rpos, *wpos;

/* Unfortunately, Linux crashes with SIGSEGV when free is called with an
  invalid block. I think that there is a fix for this - I'll try to find
  it */
/*	if(blk->mem)
		free(blk->mem); */
/* Erzeugt bei lokalen Variablen eventuell Fehler, weil sie nicht geloescht erzeugt werden! */

	if(x2 < x1)
		swap(&x1, &x2);
	if(y2 < y1)
		swap(&y1, &y2);

	if((x1 >= clip_x1) && (y1 >= clip_y1) && (x2 <= clip_x2) && (y2 <= clip_y2))
	{
		blk->w = (x2 - x1) + 1;
		blk->h = (y2 - y1) + 1;

		blk->mem = malloc(blk->w * blk->h);

		wpos = blk->mem;
		rpos = (void *)((DWORD)screen_addr + x1 + y1 * screen_width);
		for(y = y1; y <= y2; y++)
		{
			memcpy(wpos, rpos, blk->w);
			wpos = (void *)((DWORD)wpos + blk->w);
			rpos = (void *)((DWORD)rpos + screen_width);
		}
	}
}


void oldput(WORD x, WORD y, OLDBLK *blk)
{
	WORD pw, ph, py;
	BYTE *rpos, *wpos;

	if((blk->mem != NULL) && (x <= clip_x2) && (y <= clip_y2) && (x + blk->w >= clip_x1) && (y + blk->h >= clip_y1))
	{
		pw = blk->w;
		ph = blk->h;
		rpos = blk->mem;
		wpos = (BYTE *)((long)screen_addr + x + y * screen_width);
		if(x < clip_x1)
		{
			pw -= clip_x1 - x;
			rpos += clip_x1 - x;
			wpos += clip_x1 - x;
		}
		if(y < clip_y1)
		{
			ph -= clip_y1 - y;
			rpos += (clip_y1 - y) * blk->w;
			wpos += (clip_y1 - y) * screen_width;
		}
		if(x + blk->w - 1 > clip_x2)
			pw -= (x + blk->w - 1) - clip_x2;
		if(y + blk->h - 1 > clip_y2)
			ph -= (y + blk->h - 1) - clip_y2;

		for(py = 0; py < ph; py++)
		{
			memcpy(wpos, rpos, pw);
			wpos += screen_width;
			rpos += blk->w;
		}
	}
}


void oldobjput(WORD x, WORD y, OLDBLK *blk)
{
	WORD pw, ph, py, px, rplus;
	BYTE *rpos, *wpos;

	if((blk->mem != NULL) && (x <= clip_x2) && (y <= clip_y2) && (x + blk->w >= clip_x1) && (y + blk->h >= clip_y1))
	{
		pw = blk->w;
		ph = blk->h;
		rpos = blk->mem;
		rplus = 0;
		wpos = (BYTE *)((DWORD)screen_addr + x + y * screen_width);
		if(x < clip_x1)
		{
			pw -= clip_x1 - x;
			rplus += clip_x1 - x;
			rpos += clip_x1 - x;
			wpos += clip_x1 - x;
		}
		if(y < clip_y1)
		{
			ph -= clip_y1 - y;
			rpos += (clip_y1 - y) * blk->w;
			wpos += (clip_y1 - y) * screen_width;
		}
		if(x + blk->w - 1 > clip_x2)
		{
			rplus = (x + blk->w - 1) - clip_x2;
			pw -= rplus;
		}
		if(y + blk->h - 1 > clip_y2)
			ph -= (y + blk->h - 1) - clip_y2;

		for(py = 0; py < ph; py++)
		{
			for(px = 0; px < pw; px++)
			{
				if(*rpos)
					*wpos = *rpos;
				wpos++;
				rpos++;
			}
			wpos += screen_width - pw;
			rpos += rplus;
		}
	}
}


void oldaddput(WORD x, WORD y, OLDBLK *blk)
{
	WORD pw, ph, py, px, rplus;
	BYTE *rpos, *wpos;

	if((blk->mem != NULL) && (x <= clip_x2) && (y <= clip_y2) && (x + blk->w >= clip_x1) && (y + blk->h >= clip_y1))
	{
		pw = blk->w;
		ph = blk->h;
		rpos = blk->mem;
		rplus = 0;
		wpos = (BYTE *)((DWORD)screen_addr + x + y * screen_width);
		if(x < clip_x1)
		{
			pw -= clip_x1 - x;
			rpos += clip_x1 - x;
			wpos += clip_x1 - x;
		}
		if(y < clip_y1)
		{
			ph -= clip_y1 - y;
			rpos += (clip_y1 - y) * blk->w;
			wpos += (clip_y1 - y) * screen_width;
		}
		if(x + blk->w - 1 > clip_x2)
		{
			rplus = (x + blk->w - 1) - clip_x2;
			pw -= rplus;
		}
		if(y + blk->h - 1 > clip_y2)
			ph -= (y + blk->h - 1) - clip_y2;

		for(py = 0; py < ph; py++)
		{
			for(px = 0; px < pw; px++)
			{
				if(*rpos)
					*wpos += *rpos;
				wpos++;
				rpos++;
			}
			wpos += screen_width - pw;
			rpos += rplus;
		}
	}
}


void oldrotate(WORD x, WORD y, OLDBLK *obj, int rot)
{
	int lx, ly, sinus, cosinus;
	BYTE *les_addr;
	int put_x, put_y, bx, by;

	if(obj->mem != NULL)
	{
		sinus = sintab[rot];
		cosinus = sintab[rot + 90];

		put_x = min(0, ((obj->w - 1) * cosinus) >> SINFAC);
		put_y = min(0, (-(obj->w - 1) * sinus) >> SINFAC);
	
		put_x = min(put_x, ((obj->w - 1) * cosinus + (obj->h - 1) * sinus) >> SINFAC);
		put_y = min(put_y, (-(obj->w - 1) * sinus + (obj->h - 1) * cosinus) >> SINFAC);
	
		put_x = min(put_x, ((obj->h - 1) * sinus) >> SINFAC);
		put_y = min(put_y, ((obj->h - 1) * cosinus) >> SINFAC);
	
		put_x = x - put_x;
		put_y = y - put_y;

		les_addr = obj->mem;
		for(ly = 0; ly < obj->h * 2 - 1; ly++)
		{
			for(lx = 0; lx < obj->w * 2 - 1; lx++)
			{
				if(*les_addr)
				{
					bx = (ly * sinus / 2 + lx * cosinus / 2) >> SINFAC;
					by = (ly * cosinus / 2 - lx * sinus / 2) >> SINFAC;
					PutPixel(put_x + bx, put_y + by, *les_addr);
				}
				if(lx % 2 == 0)
					les_addr++;
			}
			if(ly % 2 == 0)
				les_addr -= obj->w;
		}
	}
}


void oldzoom(WORD x, WORD y, WORD w, WORD h, OLDBLK *blk)
{
	long u, v, du, dv, start_u, x_bis, y_bis, r_plus;
	BYTE *dest, *sourceRow;

	if((blk->mem != NULL) && (x < clip_x2) && (y < clip_y2) && (x + w > clip_x1) && (y + h > clip_y1))
	{
		du = (blk->w << 16) / w;
		dv = (blk->h << 16) / h;

		start_u = 0;
		v = 0;
		dest = (BYTE *)((long)screen_addr + screen_width * y + x);

		if(x + w - 1 > clip_x2)
			w -= (x + w - 1) - clip_x2;
		if(y + h - 1 > clip_y2)
			h -= (y + h - 1) - clip_y2;
		if(x < clip_x1)
		{
			start_u = (clip_x1 - x) << 16;
			w -= clip_x1 - x;
			dest = (BYTE *)((long)dest + (clip_x1 - x));
		}
		if(y < clip_y1)
		{
			v = (clip_y1 - y) << 16;
			h -= clip_y1 - y;
			dest = (BYTE *)((long)dest + (clip_y1 - y) * screen_width);
		}

		r_plus = screen_width - w;
		y_bis = (long)screen_addr + (x + w - 1) + (y + h - 1) * screen_width;

		while ((long) dest < y_bis)
		{
			u = start_u;
			sourceRow = (BYTE *)((long)blk->mem + (v >> 16) * blk->w);
			x_bis = (long)dest + w;
			while ((long) dest < x_bis)
			{
				if(sourceRow[u >> 16])
					*dest = sourceRow[u >> 16];
				dest++;
				u += du;
			}
			v += dv;
			dest = (void *)((long)dest + r_plus);
		}
	}
}


void getvollbild(void *pic)
{
	memcpy(pic, screen_addr, screen_width * screen_height);
}

void putvollbild(void *pic)
{
	GFXBLK b ;
	
	memcpy(screen_addr, pic, screen_width * screen_height);
	get(0, 0, screen_width, screen_height, & b) ;
	put(0, 0, & b) ;
	free_blk(& b) ;
}
