/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/********************************/
/* PIX-functions                */
/* (C) Mar 1996 by Michael Haar */
/********************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dn.h>

#include <bmphead.h>
#include <pcxhead.h>
#include <tgahead.h>

typedef struct
{
	char pix_id[3] PACKED ; /* "PIX" */
	BYTE version PACKED ; /* 1 */
	BYTE len PACKED ;       /* headerlen */
	WORD width PACKED ; /* of pic */
	WORD height PACKED ; /* " */
	BYTE colors PACKED ; /* 0 = 256 */
	BOOLEAN palette PACKED ; /* TRUE = Pal at end of file */
} PIX_HEADER ; /* must be PACKED for DJGPP to align correctly */

/* global vars */
extern WORD gfxmode;
extern WORD clip_x1, clip_y1, clip_x2, clip_y2;
extern long filestartpos, filelength;

/* prototypes */

BOOLEAN load_pic(char * dname, void * addr, RGB * pal);
void save_pic(char * fname, void * addr, RGB * pal);

/* functions */
void resize_pic(void *addr)
{
	char *rpos, *wpos;
	void *buffer;
	int y;

	buffer = calloc(1, MAX_SCREEN_W * MAX_SCREEN_H / 2);
	rpos = addr;
	wpos = buffer;

	if((gfxmode == 0x100) || (gfxmode == 0x101))
	{
		/* 1. Viertel */
		rpos = addr;
		wpos = buffer;
		for(y = 0; y < 200; y++)
		{
			memmove(wpos, rpos, 320);
			rpos += 320;
			wpos += screen_width;
		}
		/* 2. Viertel */
		rpos = (char *)((long)addr + 64000);
		wpos = (char *)((long)buffer + 320);
		for(y = 0; y < 200; y++)
		{
			memmove(wpos, rpos, 320);
			rpos += 320;
			wpos += screen_width;
		}
		memmove(addr, buffer, MAX_SCREEN_W * MAX_SCREEN_H / 2);
	}
	else if(gfxmode == 0x13)
	{
		/* 1. Viertel */
		rpos = addr;
		wpos = buffer;
		for(y = 0; y < 200; y++)
		{
			memmove(wpos, rpos, 320);
			rpos += 640;
			wpos += 320;
		}
		/* 2. Viertel */
		rpos = (char *)((long)addr + 320);
		wpos = (char *)((long)buffer + 64000);
		for(y = 0; y < 200; y++)
		{
			memmove(wpos, rpos, 320);
			rpos += 640;
			wpos += 320;
		}
		memmove(addr, buffer, MAX_SCREEN_W * MAX_SCREEN_H / 2);
	}
	free(buffer);
}

void load_bmp(FILE *datei, void *addr, RGB *pal)
{
	BITMAPFILEHEADER filehead;
	BITMAPINFO fileinfo;
	WORD i, y, w, h;
	BYTE *pos;

	fread(&filehead, sizeof(BITMAPFILEHEADER), 1, datei);
	fread(&fileinfo, sizeof(BITMAPINFO), 1, datei);

/* endian fix - MJT */
	_little_to_dword( & filehead.bfOffBits) ;
	_little_to_dword( & fileinfo.bmiHeader.biWidth) ;
	_little_to_dword( & fileinfo.bmiHeader.biHeight) ;
	
	w = fileinfo.bmiHeader.biWidth;
	h = fileinfo.bmiHeader.biHeight;

	fseek(datei, filestartpos + filehead.bfOffBits, SEEK_SET);

	for(y = min(h, screen_height) - 1; y >= 0; y--)
	{
		pos = (void *)((long)addr + screen_width * y);
		fread(pos, min(w, screen_width), 1, datei);
		fseek(datei, (w - screen_width), SEEK_CUR);
	}

	for(i = 0; i < 256; i++)
	{
		pal[i].r = fileinfo.bmiColors[i].rgbRed >> 2;
		pal[i].g = fileinfo.bmiColors[i].rgbGreen >> 2;
		pal[i].b = fileinfo.bmiColors[i].rgbBlue >> 2;
	}

	if(((screen_width == 640) && (w == 320)) || ((screen_width == 320) && (w == 640)))
		resize_pic(addr);
}

void load_pcx(FILE *datei, void *addr, RGB *pal)
{
	PCXHEADER header;
	PCXPALETTE pcxpal;
	int i, w, h;
	BYTE data, datacount;
	char *wpos, *bis;

	fread(&header, sizeof(PCXHEADER), 1, datei);
	wpos = addr;
	_little_to_word( & header.XMin) ;
	_little_to_word( & header.YMin) ;
	_little_to_word( & header.XMax) ;
	_little_to_word( & header.YMax) ;
	w = (header.XMax - header.XMin + 1);
	h = (header.YMax - header.YMin + 1);
	_little_to_word( & header.BytesPerLine) ;
	bis = wpos + header.BytesPerLine * (header.YMax - header.YMin + 1);
	while(wpos < bis)
	{
		datacount = 1;
		fread(&data, 1, 1, datei);
		if((data & 0xC0) == 0xC0)
		{
			datacount = data & 0x3F;
			fread(&data, 1, 1, datei);
		}
		for(i = 0; i < datacount; i++)
			*wpos++ = data;
	}
	fseek(datei, filestartpos + filelength - 769, SEEK_SET);
	fread(&pcxpal, sizeof(PCXPALETTE), 1, datei);
	if(pcxpal.mark == 0xC)
		for(i = 0; i < 256; i++)
		{
			pal[i].r = pcxpal.pal[i].r >> 2;
			pal[i].g = pcxpal.pal[i].g >> 2;
			pal[i].b = pcxpal.pal[i].b >> 2;
		}

	if(((screen_width == 640) && (w == 320)) || ((screen_width == 320) && (w == 640)))
		resize_pic(addr);
}

void load_tga(FILE *datei, void *addr, RGB *pal)
{
	TGAHEADER header;
	BYTE r, g, b;
	int i;
	int x, y, color;
	char *wpos;

	memset(pal, 0, sizeof(RGB) * 256);

	fread(&header, sizeof(TGAHEADER), 1, datei);
	fseek(datei, filestartpos + 18, SEEK_SET);

	wpos = addr;
	_little_to_word( & header.width) ;
	_little_to_word( & header.height) ;
	for(y = 0; y < header.height; y++)
		for(x = 0; x < header.width; x++)
		{
			fread(&b, 1, 1, datei);
			fread(&g, 1, 1, datei);
			fread(&r, 1, 1, datei);
			b >>= 2;
			g >>= 2;
			r >>= 2;
			color = -1;
			for(i = 0; i < 256; i++)
			{
				if((pal[i].r == r) && (pal[i].g == g) && (pal[i].b == b))
				{
					color = i;
					break;
				}
			}
			if(color == -1)
			{
				/* Keine gefunden - neue erzeugen: */
				for(i = 1; i < 256; i++)
				{
					if((pal[i].r == 0) && (pal[i].g == 0) && (pal[i].b == 0))
					{
						color = i;
						pal[i].r = r;
						pal[i].g = g;
						pal[i].b = b;
						break;
					}
				}
				if(color == -1)
				{
					/* nix passendes gefunden! - jetzt die beste suchen (siehe antialiasing) */
					color = 0; /* erstmal!!! */
				}
			}
			if(color > -1)
				*wpos++ = (BYTE)color;
		}

	if(((screen_width == 640) && (header.width == 320)) || ((screen_width == 320) && (header.width == 640)))
		resize_pic(addr);
}

void load_degas(FILE *datei, void *addr, RGB *pal)
{
	struct
	{
		WORD res ;
		WORD degaspal[16] ;
	} header ;
	void * degaspic ;
	UWORD * rpos ;
	BYTE * wpos ;
	UWORD w[4] ;
	int i, pixel ;
	UWORD bit ;
	BYTE bitplane[4] ;

	degaspic = malloc(32000) ;
	if(!degaspic)
		return ;

	fread(&header, sizeof(header), 1, datei) ;
	fread(degaspic, 32000, 1, datei) ;

	for(i = 0; i < 16; i++)
	{
		pal[i].r = ((header.degaspal[i] & 0x0007)) * 63 / 7 ;
		pal[i].g = ((header.degaspal[i] & 0x7000) >> 12) * 63 / 7 ;
		pal[i].b = ((header.degaspal[i] & 0x0700) >> 8) * 63 / 7 ;
	}

	wpos = addr ;
	rpos = degaspic ;
	for(i = 0; i < 32000 / 4; i++)
	{
		w[0] = *rpos++ ;
		_big_to_word( & w[0]) ;
		w[1] = *rpos++ ;
		_big_to_word( & w[1]) ;
		w[2] = *rpos++ ;
		_big_to_word( & w[2]) ;
		w[3] = *rpos++ ;
		_big_to_word( & w[3]) ;
		for(pixel = 0; pixel < 16; pixel++)
		{
			bit = 1 << (15 - pixel) ;
			bitplane[0] = (w[0] & bit) >> (15 - pixel) ;
			bitplane[1] = (w[1] & bit) >> (15 - pixel) ;
			bitplane[2] = (w[2] & bit) >> (15 - pixel) ;
			bitplane[3] = (w[3] & bit) >> (15 - pixel) ;
			*wpos++ = bitplane[0] + bitplane[1] * 2 + bitplane[2] * 4 + bitplane[3] * 8 ;
		}
	}

	free(degaspic) ;
}

/* load pic fname to addr and get pal */

BOOLEAN load_pic(char * testname, void * addr, RGB * pal)
{
	long len;
	void *p1;
	PIX_HEADER pixhead ;
	FILE * datei ;
	char dname[256] ;
	int r = 0 ;

	datei = open_file(testname) ;
/* cr*p hack because people won't use case correctly */
	while (testname[r])
	  {
	    dname[r] = testname[r] ;
	    r++ ;
	  }
	
	(void) strlwr(dname) ;
	if (datei)
	{
		if(strstr(dname, ".tga"))
			load_tga(datei, addr, pal);
		else if(strstr(dname, ".pi1"))
			load_degas(datei, addr, pal);
		else if(strstr(dname, ".bmp"))
			load_bmp(datei, addr, pal);
		else if(strstr(dname, ".pcx"))
			load_pcx(datei, addr, pal);
		else if(strstr(dname, ".pic"))
		{
			/* raw screendata */
			fread(addr, screen_width * screen_height, 1, datei);
			/* Palette evtl. am ende: */
			fread(pal, sizeof(RGB) * 256, 1, datei);
		}
		else if(strstr(dname, ".gif"))
		{
/*                      loadgif(dname, addr, 0, 0, pal);
				ReadLn(palplus);
				pic_to_pal(pal, palplus); */
		}
		else if(strstr(dname, ".pix"))
		{
			fread(& pixhead, sizeof(PIX_HEADER), 1, datei) ;
			_little_to_word( & pixhead.width) ;
			_little_to_word( & pixhead.height) ;
/*          fread(&pixhead.pix_id, 3, 1, datei);
			fread(&pixhead.version, 1, 1, datei);
			fread(&pixhead.len, 1, 1, datei);
			fread(&pixhead.width, 2, 1, datei);
			fread(&pixhead.height, 2, 1, datei);
			fread(&pixhead.colors, 1, 1, datei);
			fread(&pixhead.palette, 1, 1, datei);
*/          if((pixhead.pix_id[0] == 'P') && (pixhead.pix_id[1] == 'I') && (pixhead.pix_id[2] == 'X'))
			{
				p1 = malloc(max(pixhead.width, screen_width) * max(pixhead.height, screen_height));
				if(p1 == NULL)
				{
					fclose(datei);
					return(FALSE);
				}
				if((pixhead.width == 320) && (pixhead.height == 200) && (pixhead.colors == 0))
				{
					fseek(datei, filestartpos + pixhead.len, SEEK_SET);
					len = 0;
					fread(&len, 2, 1, datei);
					fread(p1, len, 1, datei);
					/* eventuell entpacken */
					if(len == screen_width * screen_height)
						memmove(addr, p1, len);
					else
						unpack_pic(p1, addr, len);
					/* Palette evtl. am Ende: */
					fread(pal, sizeof(RGB) * 256, 1, datei);
				}
				else if(pixhead.colors == 0)
				{
					fseek(datei, filestartpos + pixhead.len, SEEK_SET);
					fread(&len, 4, 1, datei);
					fread(p1, len, 1, datei);
					/* eventuell entpacken */
					if(len == screen_width * screen_height)
						memmove(addr, p1, len);
					else
						unpack_pic(p1, addr, len);
					/* Palette evtl. am }e: */
					fread(pal, sizeof(RGB) * 256, 1, datei);
				}
				if(((screen_width == 640) && (pixhead.width == 320)) || ((screen_width == 320) && (pixhead.width == 640)))
					resize_pic(addr);
			}
			else
			{
				p1 = malloc(screen_width * screen_height);
				fseek(datei, filestartpos, SEEK_SET);
				pixhead.palette = TRUE; /* Einfach mal gucken! */
				fread(&len, 2, 1, datei);
				fread(p1, len, 1, datei);
				unpack_pic(p1, addr, len);
				/* Palette evtl. am }e: */
				fread(pal, sizeof(RGB) * 256, 1, datei);
			}
			free(p1);
		}
		else
		{
			fclose(datei) ;
			return(FALSE) ;
		}
		fclose(datei);
		return(TRUE);
	}
	else
		return(FALSE);
}

void save_bmp(FILE *datei, void *addr, RGB *pal)
{
	BITMAPFILEHEADER filehead;
	BITMAPINFO fileinfo;
	WORD i, y, w, h;
	BYTE *pos;

	memset(&filehead, 0, sizeof(BITMAPFILEHEADER));
	memset(&fileinfo, 0, sizeof(BITMAPINFO));
	/* und los: */
	memcpy(&filehead.bfType, "BM", 2);
	filehead.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFO) + screen_width * screen_height;;
	_dword_to_little( & filehead.bfSize) ;
	filehead.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFO);
        _dword_to_little( & filehead.bfOffBits) ;
        
	fileinfo.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	_dword_to_little( & fileinfo.bmiHeader.biSize) ;
	w = fileinfo.bmiHeader.biWidth = screen_width;
	_dword_to_little( & fileinfo.bmiHeader.biWidth) ;
	h = fileinfo.bmiHeader.biHeight = screen_height;
	_dword_to_little( & fileinfo.bmiHeader.biHeight) ;
	fileinfo.bmiHeader.biPlanes = 1;
	_word_to_little( & fileinfo.bmiHeader.biPlanes) ;
	fileinfo.bmiHeader.biBitCount = 8;
	_word_to_little(& fileinfo.bmiHeader.biBitCount) ;
	fileinfo.bmiHeader.biCompression = 0;   /* ??? */
	fileinfo.bmiHeader.biSizeImage = screen_width * screen_height;
	_dword_to_little( & fileinfo.bmiHeader.biSizeImage) ;
	fileinfo.bmiHeader.biXPelsPerMeter = 0;
	fileinfo.bmiHeader.biClrUsed = 0;
	fileinfo.bmiHeader.biClrImportant = 0;

	for(i = 0; i < 256; i++)
	{
		fileinfo.bmiColors[i].rgbRed = pal[i].r << 2;
		fileinfo.bmiColors[i].rgbGreen = pal[i].g << 2;
		fileinfo.bmiColors[i].rgbBlue = pal[i].b << 2;
		fileinfo.bmiColors[i].rgbReserved = 0;
	}

	fwrite(&filehead, sizeof(BITMAPFILEHEADER), 1, datei);
	fwrite(&fileinfo, sizeof(BITMAPINFO), 1, datei);

	for(y = h - 1; y >= 0; y--)
	{
		pos = (void *)((long)addr + w * y);
		fwrite(pos, w, 1, datei);
	}
}

void save_pcx(FILE *datei, void *addr, RGB *pal)
{
	PCXHEADER header;
	PCXPALETTE pcxpal;
	int i, datacount;
	BYTE data;
	char *rpos, *bis;

	memset(&header, 0, sizeof(PCXHEADER));
	header.manufacturer = 0x0A;
	header.version = 5;      /* VGA with pal */
	header.encoding = 1;
	header.BitsPerPixel = 8;
	header.XMin = 0;
	header.YMin = 0;
	header.XMax = screen_width - 1;
	_word_to_little( & header.XMax) ;
	header.YMax = screen_height - 1;
	_word_to_little( & header.YMax) ;
	header.HDpi = 320;
	_word_to_little( & header.HDpi) ;
	header.VDpi = 200;
	_word_to_little( & header.VDpi) ;
	header.Reserved = 0;
	header.NPlanes = 1;
	header.BytesPerLine = clip_x2 - clip_x1 + 1;
	_word_to_little( & header.BytesPerLine) ;
	header.PaletteInfo = 1;
	_word_to_little( & header.PaletteInfo) ;
	header.HscreenSize = screen_height;
	_word_to_little( & header.HscreenSize) ;
	header.VscreenSize = screen_width;
	_word_to_little( & header.VscreenSize) ;
	fwrite(&header, sizeof(PCXHEADER), 1, datei);
	rpos = addr;
	bis = rpos + screen_width * screen_height - 1;
	while(rpos <= bis)
	{
		datacount = 1;
		data = *rpos;
		while((rpos < bis) && (*rpos == *(rpos + 1)) && (datacount < 63))
		{
			datacount++;
			rpos++;
		}
		rpos++;
		if((datacount == 1) && ((data & 0xC0) != 0xC0))
			fwrite(&data, 1, 1, datei);
		else
		{
			datacount |= 0xC0;
			fwrite(&datacount, 1, 1, datei);
			fwrite(&data, 1, 1, datei);
		}
	}
	pcxpal.mark = 0xC;
	for(i = 0; i < 256; i++)
	{
		pcxpal.pal[i].r = pal[i].r << 2;
		pcxpal.pal[i].g = pal[i].g << 2;
		pcxpal.pal[i].b = pal[i].b << 2;
	}
	fwrite(&pcxpal, sizeof(PCXPALETTE), 1, datei);
}

/* Bild unter Dateiname speichern - Format je nach }ung: */

void save_pic(char * testname, void * addr, RGB * pal)
{
	long len;
	FILE *datei;
	void *pmem;
	PIX_HEADER pixhead;
	char fname[256] ;
	int r = 0 ;
	
	datei = fopen(fname, "wb");
/* cr*p hack because people won't use case correctly */
	while (testname[r])
	  {
	    fname[r] = testname[r] ;
	    r++ ;
	  }
	
	(void) strlwr(fname) ;
	if(strstr(fname, ".pcx"))
		save_pcx(datei, addr, pal);
	else if(strstr(fname, ".bmp"))
		save_bmp(datei, addr, pal);
	else if(strstr(fname, ".pix"))
	{
		pixhead.pix_id[0] = 'P';
		pixhead.pix_id[1] = 'I';
		pixhead.pix_id[2] = 'X';
		pixhead.version = 2;
		pixhead.len = sizeof(PIX_HEADER);
		pixhead.width = screen_width;
		_word_to_little( & pixhead.width) ;
		pixhead.height = screen_height;
		_word_to_little( & pixhead.height) ;
		pixhead.colors = 0;
		pixhead.palette = TRUE;
		fwrite(&pixhead.pix_id, sizeof(PIX_HEADER), 1, datei);
/*              fwrite(&pixhead.pix_id, 3, 1, datei);
		fwrite(&pixhead.version, 1, 1, datei);
		fwrite(&pixhead.len, 1, 1, datei);
		fwrite(&pixhead.width, 2, 1, datei);
		fwrite(&pixhead.height, 2, 1, datei);
		fwrite(&pixhead.colors, 1, 1, datei);
		fwrite(&pixhead.palette, 1, 1, datei); */

		pmem = malloc(screen_width * screen_height + 1024); /* 1024 mal als Reserve */
		if(pmem)
		{
			len = pack_pic(addr, pmem, screen_width * screen_height);
			if(len == 0)
			{
				/* save unpacked */
				memmove(pmem, addr, screen_width * screen_height);
				len = screen_width * screen_height;
			}

			if((screen_width == 320) && (screen_height == 200))
				fwrite(&len, 2, 1, datei);
			else if((screen_width == 640) && (screen_height == 400))
				fwrite(&len, 4, 1, datei);
			fwrite(pmem, len, 1, datei);
			free(pmem);
		}
		else
		{
			len = screen_width * screen_height;
			if((screen_width == 320) && (screen_height == 200))
				fwrite(&len, 2, 1, datei);
			else if((screen_width == 640) && (screen_height == 400))
				fwrite(&len, 4, 1, datei);
			fwrite(addr, len, 1, datei);
		}

		/* Palette hinter die Datei abspeichern: */
		fwrite(pal, sizeof(RGB) * 256, 1, datei);
	}
	else
	{
		fwrite(addr, screen_width * screen_height, 1, datei);
		/* Palette hinter die Datei abspeichern: */
		fwrite(pal, sizeof(RGB) * 256, 1, datei);
	}
	fclose(datei);
}
