/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/********************************/
/* DNSVGA-Funcs: Palette        */
/* (C) Mar 1996 by Michael Haar */
/********************************/

#include <stdlib.h>
#include <string.h>
#include <dn.h>

/* global vars */
RGB alt_rgb[256];
RGB fadepal[256] ;

extern WORD gfxmode;

/* prototypes */
inline void SetPalette(RGB * pal);
inline void ClearPalette(RGB * pal);
void PaletteFadeIn(RGB * pal);
void PaletteFadeOut(RGB * pal);
void sort_palette(RGB * pal, RGB * pal2);

extern void wait_retrace(void);

/* functions */

inline void SetPalette(RGB * pal)
{
	SetColors(pal, 0, 256) ;
}

inline void ClearPalette(RGB *pal)
{
	memset(pal, 0, sizeof(RGB) * 256);
}

void PaletteFadeIn(RGB * pal)
{
	int i, c;

	memset(fadepal, 0, sizeof(RGB) * 256);
	for(i = 0; i < 64; i++)
	{
		for(c = 0; c < 256; c++)
		{
			if(fadepal[c].r < pal[c].r)
				fadepal[c].r++;
			if(fadepal[c].g < pal[c].g)
				fadepal[c].g++;
			if(fadepal[c].b < pal[c].b)
				fadepal[c].b++;
		}
		SetPalette(& fadepal[0]);
	}
}

void PaletteFadeOut(RGB *pal)
{
	int i, c;

	memmove(&fadepal, pal, sizeof(RGB) * 256);

	for(i = 0; i < 64; i++)
	{
		for(c = 0; c < 256; c++)
		{
			if(fadepal[c].r > 0)
				fadepal[c].r--;
			if(fadepal[c].g > 0)
				fadepal[c].g--;
			if(fadepal[c].b > 0)
				fadepal[c].b--;
		}
		SetPalette(fadepal);
	}
}

void sort_palette(RGB *pal, RGB *pal2)
{
	int cnt1, cnt2, kleinst, gew;

	for(cnt1 = 0; cnt1 < 256; cnt1++)
	{
		kleinst = 256;
		gew = 0;
		for(cnt2 = 0; cnt2 < 256; cnt2++)
		{
			if(pal[cnt2].r + pal[cnt2].g + pal[cnt2].b < kleinst)
			{
				gew = cnt2;
				kleinst = pal[cnt2].r + pal[cnt2].g + pal[cnt2].b;
			}
		}
		pal2[cnt1] = pal[gew];
		pal[gew].r = 255;
		pal[gew].g = 255;
		pal[gew].b = 255;
	}
}

