/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/********************************/
/* DNSVGA-Funcs: Fonts          */
/* (C) Mar 1996 by Michael Haar */
/********************************/

/* ACHTUNG: speicher frs getten wird nicht freigegeben falls der Font schon belegt ist */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <dn.h>

/* global vars */
FONT schrift ;

/* prototypes */
BOOLEAN load_font(const char *fname, WORD start_y, char start_ch, WORD char_w, WORD char_h, FONT *fnt);

void put_text(FONT *fnt, WORD x, WORD y, const unsigned char *txt);
void show_text(FONT *fnt, WORD x, WORD y, const unsigned char *txt);

char *get_text(FONT *fnt, WORD x, WORD y, char *txt);
char upper_case(char c) ;

/* functions */
BOOLEAN load_font(const char *fname, WORD start_y, char start_ch, WORD char_w, WORD char_h, FONT *fnt)
{
	void *mem, *alt_screen;
	int i, chars_row;
	RGB d[256];

	if(start_ch)
		start_ch -= ' ';

	mem = malloc(MAX_SCREEN_W * MAX_SCREEN_H);
	if(!mem)
		return(FALSE);

	if(!load_pic(fname, mem, d))
	{
		free(mem);
		return(FALSE);
	}

	alt_screen = screen_addr;
	screen_addr = mem;
	fnt->char_w = char_w;
	fnt->char_h = char_h;
	chars_row = screen_width / char_w;
	for(i = 0; i < FONT_CHARS - start_ch; i++)
		get((i % chars_row) * char_w, start_y + i / chars_row * char_h,
			((i % chars_row) + 1) * char_w - 1, start_y + ((i / chars_row) + 1) * char_h - 1,
			&fnt->char_pic[start_ch + i]);
	screen_addr = alt_screen;

	free(mem);

	return(TRUE);
}

void put_text(FONT *fnt, WORD x, WORD y, const unsigned char *txt)

{
	int i;

	for(i = 0; i < strlen(txt); i++)
		if((txt[i] >= 32) && (txt[i] <= 127))
			objput(x + i * fnt->char_w, y, &fnt->char_pic[txt[i] - 32]);
}

void show_text(FONT *fnt, WORD x, WORD y, const unsigned char *txt)

{
	int i;

	for(i = 0; i < strlen(txt); i++)
		if((txt[i] >= 32) && (txt[i] <= 127))
		{
			box(x + i * fnt->char_w, y, x + (i + 1) * fnt->char_w - 1, y + fnt->char_h - 1, 0, TRUE, FALSE);
			objput(x + i * fnt->char_w, y, &fnt->char_pic[txt[i] - 32]);
		}
}

char *get_text(FONT *fnt, WORD x, WORD y, char *txt)
{
	char ch;

	strcpy(txt, "") ;
	do {
		show_text(fnt, x, y, txt);
		Copy2Screen();
		ch = get_key() ;
		if(ch) {
			ch = upper_case(ch) ;
			switch(ch) {
				case 13:
					break;
				case 8:
					if(strlen(txt) > 0)
						txt[strlen(txt) - 1] = 0;
					break;
				default:
					if((ch > 32) && (ch < 127)) {
						txt[strlen(txt) + 1] = 0;
						txt[strlen(txt)] = ch;
					}
			}
		}
	}
	while(ch != 13);
	return(txt);
}

char upper_case(char c)
{
    if ( (c <= 'z') && (c >= 'a'))
      {
        c = (char) ( ( (int) c) + 'A' - 'a') ;
      }
    return(c) ;
}
