/*
Copyright (c) 1998 Michael Haar, Ulrich Haar, Michael Thayer,
  Tobias Mueller, Tobias Lenz
All rights reserved.
Terroid Programming by Michael Haar, Michael Thayer, Ulrich Haar
Terroid Graphics by Ulrich Haar, Michael Haar
Terroid Music by Michael Thayer
Terroid Level design by Michael Haar, Ulrich Haar, Tobias Lenz
Terroid Beta testing by Tobias Mueller, Tobias Lenz

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice and credits, this unmodified list of conditions and the
   following disclaimer in the documentation and/or other materials
   provided with the distribution.
3. Any credits displayed during programme execution must include the
   above or an equivalent credit list.
4. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.
5. The authors Michael Thayer and Michael Haar are to be informed,
   preferable by electronic mail, when this software is distributed
   commercially.  A single notification is required for any given
   distribution, and explicit copies of that distribution (e.g. for all
   resellers of a given Linux distribution).
6. If any modifications are made to the software, then a description of them
   must be included when the software is redistributed, or alternatively,
   the distributed binary or source code must be described as a product
   based on source code by Michael Haar, Michael Thayer and Ulrich Haar.

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/********************************/
/* DNSVGA-Funcs: Drawing        */
/* (C) Mar 1996 by Michael Haar */
/********************************/

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <dn.h>

/* global vars */
BYTE rainbow_c1, rainbow_c2;

/* prototypes */
void PutPixel(WORD x, WORD y, BYTE color);
BYTE GetPixel(WORD x, WORD y);
void fbox(WORD x1, WORD y1, WORD x2, WORD y2, BYTE color);
void line(WORD x1, WORD y1, WORD x2, WORD y2, BYTE color, BOOLEAN rainbow);
void box(WORD x1, WORD y1, WORD x2, WORD y2, BYTE c, BOOLEAN fill, BOOLEAN rainbow);
void flood_fill(WORD x, WORD y, BYTE c, BOOLEAN rainbow);
void ellipse_circle(BOOLEAN circle, WORD x, WORD y, WORD r1, WORD r2, BYTE c, BOOLEAN fill, BOOLEAN rainbow);

void cls(BYTE colour) ;

extern void swap(WORD *a, WORD *b);

/* functions */
void PutPixel(WORD x, WORD y, BYTE color)
{
	if((x >= clip_x1) && (x <= clip_x2) && (y >= clip_y1) && (y <= clip_y2))
		*(BYTE *)((long)screen_addr + x + y * screen_width) = color;
}

BYTE GetPixel(WORD x, WORD y)
{
	if((x >= clip_x1) && (x <= clip_x2) && (y >= clip_y1) && (y <= clip_y2))
		return(*(BYTE *)((long)screen_addr + x + y * screen_width));
	else
		return(0);
}

void fbox(WORD x1, WORD y1, WORD x2, WORD y2, BYTE color)
{
	WORD pw, ph, py;
	BYTE *wpos;

	if(x1 > x2)
		swap(&x1, &x2);
	if(y1 > y2)
		swap(&y1, &y2);
	if((x1 <= clip_x2) && (y1 <= clip_y2) && (x2 >= clip_x1) && (y2 >= clip_y1))
	{
		pw = abs(x2 - x1) + 1;
		ph = abs(y2 - y1) + 1;
		wpos = (BYTE *)((long)screen_addr + x1 + y1 * screen_width);
		if(x1 < clip_x1)
		{	
			pw -= clip_x1 - x1;
			wpos += clip_x1 - x1;
		}
		if(y1 < clip_y1)
		{
			ph -= clip_y1 - y1;
			wpos += clip_y1 - y1 * screen_width;
		}
		if(x2 > clip_x2)
			pw -= x2 - clip_x2;
		if(y2 > clip_y2)
			ph -= y2 - clip_y2;

		for(py = 0; py < ph; py++)
		{
			memset(wpos, color, pw);
			wpos += screen_width;
		}
	}
}

void line(WORD x1, WORD y1, WORD x2, WORD y2, BYTE color, BOOLEAN rainbow)
{
	double xsteig, ysteig, xpos, ypos, fpos, fsteig;
	WORD xu, yu, i, f1, f2;

	xpos = x1;
	ypos = y1;
	xu = (x2 - x1);
	yu = (y2 - y1);
	if(!rainbow)
	{
		fpos = color;
		f2 = color;
		f1 = color;
	}
	else
	{
		f1 = rainbow_c1;
		f2 = rainbow_c2;
		fpos = f1;
	}
	if(abs(xu) > abs(yu))
	{
		if(xu < 0)
		{
			xpos = x2;
			ypos = y2;
			x2 = x1;
			fpos = f2;
		}
		if(xu != 0)
		{
			ysteig = (double)yu / xu;
			fsteig = (double)(f2 - f1) / xu;
			for(i = (WORD)xpos; i <= x2; i++)
			{
				PutPixel(i, (WORD)ypos, (WORD)fpos);
				ypos = ypos + ysteig;
				fpos = fpos + fsteig;
			}
		}
	}
	else
	{
		if(yu < 0)
		{
			ypos = y2;
			xpos = x2;
			y2 = y1;
			fpos = f2;
		}
		if(yu != 0)
		{
			xsteig = (double)xu / yu;
			fsteig = (double)(f2 - f1) / yu;
			for(i = (WORD)ypos; i <= y2; i++)
			{
				PutPixel((WORD)xpos, i, (WORD)fpos);
				xpos = xpos + xsteig;
				fpos = fpos + fsteig;
			}
		}
	}
}

/*
void box(WORD x1, WORD y1, WORD x2, WORD y2, BYTE c, BOOLEAN fill, BOOLEAN rainbow)
{
	int y;

	if(!fill)
	{
		line(x1, y1, x2, y1, c, rainbow);
		line(x1, y1, x1, y2, c, rainbow);
		line(x2, y1, x2, y2, c, rainbow);
		line(x1, y2, x2, y2, c, rainbow);
	}
	else
	{
		if(!rainbow)
			fbox(x1, y1, x2, y2, c);
		else
		{
			if(y1 > y2)
				swap(&y2, &y1);
			for(y = y1; y <= y2; y++)
				line(x1, y, x2, y, c, rainbow);
		}
	}
}
*/

void flood_fill(WORD x, WORD y, BYTE c, BOOLEAN rainbow)
{
	#define STACKSIZE 500

	typedef struct
	{
		WORD x, y;
	} POINT;

	POINT Stack[STACKSIZE + 1];
	int StackPointer;
	BOOLEAN oben_frei, vorher_oben_frei, unten_frei, vorher_unten_frei;
	BYTE fuellfarbe, color;
	int rainbow_range;
	WORD px, py;
	double bx, by;

	/* for rainbow: */
	rainbow_range = abs(rainbow_c2 - rainbow_c1);

	px = x;
	py = y;

	StackPointer = 0;
	fuellfarbe = GetPixel(x, y);
	if(fuellfarbe == c)	/* no double filling */
		return;
	while(StackPointer >= 0)
	{
		while((x >= 0) && (GetPixel(x, y) == fuellfarbe))
			x--;

		x++;
		oben_frei = FALSE;
		unten_frei = FALSE;
		while((x <= clip_x2) && (GetPixel(x, y) == fuellfarbe))
		{
			vorher_oben_frei = oben_frei;
			oben_frei = FALSE;
			if(y > 0)
			{
				if(GetPixel(x, y - 1) == fuellfarbe)
					oben_frei = TRUE;
				if(!vorher_oben_frei && oben_frei)
					if(StackPointer <= STACKSIZE)
					{
						Stack[StackPointer].x = x;
						Stack[StackPointer].y = y - 1;
						StackPointer++;
					}
			}
			vorher_unten_frei = unten_frei;
			unten_frei = FALSE;
			if(y < clip_y2)
			{
				if(GetPixel(x, y + 1) == fuellfarbe)
					unten_frei = TRUE;
				if(!vorher_unten_frei && unten_frei)
					if(StackPointer <= STACKSIZE)
					{
						Stack[StackPointer].x = x;
						Stack[StackPointer].y = y + 1;
						StackPointer++;
					}
			}
			if(rainbow)
			{
				bx = abs(x - px);
				by = abs(y - py);
				do
				{
					color = min(rainbow_c1, rainbow_c2) + (BYTE)(sqrt(bx * bx + by * by)
						/ (double)rainbow_range * 2.5) + rand() % 2;
				}
				while((color <= fuellfarbe) && (rand() % 100 < 98)); /* Mogelloesung mit rand() */
				PutPixel(x, y, color);
			}
			else
				PutPixel(x, y, c);
			x++;
		}
		StackPointer--;
		if(StackPointer >= 0)
		{
			x = Stack[StackPointer].x;
			y = Stack[StackPointer].y;
		}
	}
}

void ellipse_circle(BOOLEAN circle, WORD x, WORD y, WORD r1, WORD r2, BYTE c, BOOLEAN fill, BOOLEAN rainbow)
{
	int ZFAK;
	int grad;
	WORD kx, ky;

	if(gfxmode == 0x100)
		ZFAK = 6;
	else
		ZFAK = 3;

	if(!fill)
	{
		for(grad = 0; grad < 90 * (ZFAK + 4); grad++)
		{
			kx = (WORD)(sin(grad * PI / 180 / (ZFAK + 4)) * abs(x - r1));
			if(circle)
				ky = (WORD)(cos(grad * PI / 180 / (ZFAK + 4)) * abs(x - r1));
			else
				ky = (WORD)(cos(grad * PI / 180 / (ZFAK + 4)) * abs(y - r2));
			PutPixel(x + kx, y + ky, c);
			PutPixel(x - kx, y - ky, c);
			PutPixel(x + kx, y - ky, c);
			PutPixel(x - kx, y + ky, c);
		}
	}
	else
	{
		for(grad = 0; grad < 90 * ZFAK; grad++)
		{
			kx = (WORD)(sin(grad * PI / 180 / ZFAK) * abs(x - r1));
			if(circle) 
				ky = (WORD)(cos(grad * PI / 180 / ZFAK) * abs(x - r1));
			else
				ky = (WORD)(cos(grad * PI / 180 / ZFAK) * abs(y - r2));
			line(x + kx, y + ky, x - kx, y + ky, c, rainbow);
			line(x + kx, y - ky, x - kx, y - ky, c, rainbow);
		}
	}
}

/* void cls(BYTE colour)
{
	(void) memset(screen_addr, (char) colour, screen_len * 4) ;
} */ /* cls */
