/*
	cl_pred.c
	client side player movement prediction

	$Id: cl_pred.c,v 1.13 2008/02/07 09:27:24 sezero Exp $
*/

#include "quakedef.h"
#ifdef PLATFORM_WINDOWS
#include "winquake.h"
#endif

static	cvar_t	cl_nopred = {"cl_nopred", "0", CVAR_NONE};
static	cvar_t	cl_pushlatency = {"pushlatency", "-50", CVAR_ARCHIVE};

extern	frame_t		*view_frame;
static	qboolean player_crouching;

#if 0	/* not used */
/*
=================
CL_NudgePosition

If pmove.origin is in a solid position,
try nudging slightly on all axis to
allow for the cut precision of the net coordinates
=================
*/
void CL_NudgePosition (void)
{
	vec3_t	base;
	int		x, y;

	if (PM_HullPointContents(&cl.model_precache[1]->hulls[1], 0, pmove.origin) == CONTENTS_EMPTY)
		return;

	VectorCopy (pmove.origin, base);
	for (x = -1; x <= 1; x++)
	{
		for (y = -1; y <= 1; y++)
		{
			pmove.origin[0] = base[0] + x * 1.0/8;
			pmove.origin[1] = base[1] + y * 1.0/8;
			if (PM_HullPointContents(&cl.model_precache[1]->hulls[1], 0, pmove.origin) == CONTENTS_EMPTY)
				return;
		}
	}
	Con_DPrintf ("CL_NudgePosition: stuck\n");
}
#endif	/* CL_NudgePosition */

/*
==============
CL_PredictUsercmd
==============
*/
void CL_PredictUsercmd (player_state_t *from, player_state_t *to, usercmd_t *u, qboolean spectate)
{
	// split up very long moves
	if (u->msec > 50)
	{
		player_state_t	temp;
		usercmd_t	split;

		split = *u;
		split.msec /= 2;

		CL_PredictUsercmd (from, &temp, &split, spectate);
		CL_PredictUsercmd (&temp, to, &split, spectate);
		return;
	}

//	Con_Printf("O  %hd %hd %hd\n",u->forwardmove, u->sidemove, u->upmove);

	VectorCopy (from->origin, pmove.origin);
//	VectorCopy (from->viewangles, pmove.angles);
	VectorCopy (u->angles, pmove.angles);
	VectorCopy (from->velocity, pmove.velocity);

	pmove.oldbuttons = from->oldbuttons;
	pmove.waterjumptime = from->waterjumptime;
	pmove.dead = cl.v.health <= 0;
	pmove.spectator = spectate;
	pmove.hasted = cl.v.hasted;
	pmove.movetype = cl.v.movetype;
	pmove.teleport_time = cl.v.teleport_time;

	pmove.cmd = *u;
	pmove.crouched = player_crouching;

	PlayerMove ();
//	for (i = 0; i < 3; i++)
//		pmove.origin[i] = ((int)(pmove.origin[i]*8))*0.125;
	to->waterjumptime = pmove.waterjumptime;
	to->oldbuttons = pmove.cmd.buttons;
	VectorCopy (pmove.origin, to->origin);
	VectorCopy (pmove.angles, to->viewangles);
	VectorCopy (pmove.velocity, to->velocity);
	to->onground = onground;

	to->weaponframe = from->weaponframe;
}


/*
==============
CL_PredictMove
==============
*/
void CL_PredictMove (void)
{
	int			i;
	float		f;
	frame_t		*from, *to = NULL;
	int			oldphysent;

	if (cl_pushlatency.value > 0)
		Cvar_Set ("pushlatency", "0");

	cl.time = realtime - cls.latency - cl_pushlatency.value*0.001;
	if (cl.time > realtime)
		cl.time = realtime;

	if (cl.intermission)
		return;

	if (!cl.validsequence)
		return;

	if (cls.netchan.outgoing_sequence - cls.netchan.incoming_sequence >= UPDATE_BACKUP-1)
		return;

	VectorCopy (cl.viewangles, cl.simangles);

	// this is the last frame received from the server
	from = &cl.frames[cls.netchan.incoming_sequence & UPDATE_MASK];
	player_crouching = ((from->playerstate[cl.playernum].flags) & PF_CROUCH)>>10;

	// we can now render a frame
	if (cls.state == ca_onserver)
	{	// first update is the final signon stage
		char		text[1024];
		cls.state = ca_active;

		q_snprintf (text, sizeof(text), "HexenWorld: %s", cls.servername);
#ifdef PLATFORM_WINDOWS
		SetWindowText (mainwindow, text);
#endif
	}

	if (cl_nopred.integer)
	{
		VectorCopy (from->playerstate[cl.playernum].velocity, cl.simvel);
		VectorCopy (from->playerstate[cl.playernum].origin, cl.simorg);
		return;
	}

	// predict forward until cl.time <= to->senttime
	oldphysent = pmove.numphysent;
	CL_SetSolidPlayers (cl.playernum);

//	to = &cl.frames[cls.netchan.incoming_sequence & UPDATE_MASK];

	for (i = 1; i < UPDATE_BACKUP-1 && cls.netchan.incoming_sequence+i < cls.netchan.outgoing_sequence; i++)
	{
		to = &cl.frames[(cls.netchan.incoming_sequence+i) & UPDATE_MASK];
		CL_PredictUsercmd (&from->playerstate[cl.playernum],
					&to->playerstate[cl.playernum],
					&to->cmd, cl.spectator);

		if (to->senttime >= cl.time)
			break;

		from = to;
	}

	pmove.numphysent = oldphysent;

	if (i == UPDATE_BACKUP-1 || !to)
		return;		// net hasn't deliver packets in a long time...

	// now interpolate some fraction of the final frame
	if (to->senttime == from->senttime)
	{
		f = 0;
	}
	else
	{
		f = (cl.time - from->senttime) / (to->senttime - from->senttime);

		if (f < 0)
			f = 0;
		if (f > 1)
			f = 1;
	}

	for (i = 0; i < 3; i++)
	{
		if ( fabs(from->playerstate[cl.playernum].origin[i] - to->playerstate[cl.playernum].origin[i]) > 128)
		{	// teleported, so don't lerp
			VectorCopy (to->playerstate[cl.playernum].velocity, cl.simvel);
			VectorCopy (to->playerstate[cl.playernum].origin, cl.simorg);
			return;
		}
	}

	for (i = 0; i < 3; i++)
	{
		cl.simorg[i] = from->playerstate[cl.playernum].origin[i] +
				f * (to->playerstate[cl.playernum].origin[i] - from->playerstate[cl.playernum].origin[i]);
		cl.simvel[i] = from->playerstate[cl.playernum].velocity[i] +
				f * (to->playerstate[cl.playernum].velocity[i] - from->playerstate[cl.playernum].velocity[i]);
	}

/*	Con_Printf("(%5.2f %5.2f %5.2f)  (%5.2f %5.2f %5.2f)\n",
			cl.simorg[0] - to->playerstate[cl.playernum].origin[0],
			cl.simorg[1] - to->playerstate[cl.playernum].origin[1],
			cl.simorg[2] - to->playerstate[cl.playernum].origin[2],
			cl.simvel[0] - to->playerstate[cl.playernum].velocity[0],
			cl.simvel[1] - to->playerstate[cl.playernum].velocity[1],
			cl.simvel[2] - to->playerstate[cl.playernum].velocity[2]);
*/
}


/*
==============
CL_InitPrediction
==============
*/
void CL_InitPrediction (void)
{
	Cvar_RegisterVariable (&cl_pushlatency);
	Cvar_RegisterVariable (&cl_nopred);
}

