0<?  
class calendario 
{
	var $dia;
	var $mes;
	var $anno;
	var $url;
	var $target;

	var $numletra;
	var $numtamanno;
	var $numcolor;
	var $numfondo;
	
	var $titletra;
	var $tittamanno;
	var $titcolor;
	var $titfondo;

	var	$alineacion;
	var $borde;
	var $col_ancho;
	var $col_alto;
	
	var $DEBUG = 0;

	function calendario($anno=0, $mes=99, $dia=99){
		$this->init($anno, $mes, $dia);
	}

	function init($anno, $mes, $dia) {
		
		$this->setFecha($anno, $mes, $dia);
		$this->setNumeros();
		$this->setTitulo();
		$this->setTabla();
		$this->setUrl();
		

	} //FIN functino init
	
	function setFecha($anno, $mes, $dia) {
		
		/* Comprobamos el ao */
		if ($anno > 0 AND $anno < 32767) {
			$this->anno = $anno;
		} else {
			$this->anno = intval(date("Y"));
		}
		
		/* Comprobamos el mes */
		if ($mes > 0 AND $mes < 13) {
			$this->mes = $mes;
		} else {
			$this->mes = intval(date("m"));
		}

		/* Comprobamos el da */
		if (checkdate($this->mes, $dia, $this->anno)) {
			$this->dia = $dia;
		} else {
			$this->dia = intval(date("d"));
		}

	} // FIN function setFecha

	function setNumeros($letra= "Arial", $tamanno = "2", $color = "#FFFF00", $fondo = "#AA6F00") {
		
		$this->numletra = $letra;
		if (is_int($tamano)) {
			$this->numtamanno = strval($tamanno);
		} else {
			$this->numtamanno = $tamanno;
		}
		$this->numcolor = $color;
		$this->numfondo = $fondo;

	} //FIN function setNumeros
	
	function setTitulo($letra= "Arial", $tamanno = "2", $color = "#FFFFFF", $fondo = "0000FF") {
		
		$this->titletra = $letra;
		if (is_int($tamano)) {
			$this->tittamanno = strval($tamanno);
		} else {
			$this->tittamanno = $tamanno;
		}
		$this->titcolor = $color;
		$this->titfondo = $fondo;

	} //FIN function setTitulo


	function setTabla($alin = "center", $borde=1, $ancho=35, $alto=30) {

		$this->alineacion = $alin;
		$this->borde = strval($borde);
		$this->col_ancho = strval($ancho);
		$this->col_alto = strval($alto);
	
	} //FIN function setTabla

	function setUrl($url="", $target=""){

		$this->url = $url;
		$this->target = $target;

	} //FIN funtion setUrl


	function imprimir()
	{

		/* tabla con los dias de la semana */
		//$semana = array ("Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sbado", "Domingo");
		$semana = array (1=>"Lun", "Mar", "Mie", "Jue", "Vie", "Sb", "Dom");
		
		//$nombremes = array (1=>"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
		
		$nombremes = array (1=>"ENERO", "FEBRERO", "MARZO", "ABRIL", "MAYO", "JUNIO", "JULIO", "AGOSTO", "SEPTIEMBRE", "OCTUBRE", "NOVIEMBRE", "DICIEMBRE");


		/*  Clculamos cuantos das tiene el mes  */ 
		$ultimodia = 31;
		while (! checkdate($this->mes, $ultimodia, $this->anno)){
			$ultimodia -= 1; 
		}

		/* Clculamos nmero de dia de la semana del primer dia del mes seleccionado */
		$DiaSemanaPrimerDiaMes  =  date('w', mktime(0,0,0,$this->mes,1,$this->anno));

		// en EEUU el domingo es el primer da de la semana (domingo=0)
		if ($DiaSemanaPrimerDiaMes == 0 ) {
			$DiaSemanaPrimerDiaMes = 7 ;
		} 
		
		// para depurar
		if ($this->DEBUG) {
			echo "Ao: ".$this->anno."<br>\n";
			echo "Mes: ".$this->mes." - ".$nombremes[$this->mes]."<br>\n";
			echo "Dia: ".$this->dia."<br>\n";
			echo "Dia de la semana 1er. da del Mes: ".$DiaSemanaPrimerDiaMes;
		}

		echo "<div align='$this->alineacion'>\n";
		//<center>

		/*  Create a table with days of the week headers  */ 
		echo "<table border='$this->borde' cellpaddig='0' cellspacing='0'>\n";

		// Imprimimos el Mes y el Ao"
		$alto_tit = $this->col_alto + 10;
		echo "<tr> \n"; 
		echo "<td colspan='7' align='center' bgcolor='$this->titfondo' height='$alto_tit'>";
		echo "<b><font face='$this->titletra' size='$this->tittamanno' color='$this->titcolor'>";
		echo $nombremes[$this->mes]." de ".$this->anno."</font></b></td>\n";
		echo "</tr> \n"; 

		// nombre de los dias de la semana
		echo "<tr> \n"; 
		for ($i = 1; $i <= count($semana); $i++) {
			echo "<td align='center' bgcolor='$this->titfondo' height='$this->col_alto' width='$this->col_ancho'>\n";
			echo "<b><font face='$this->titletra' size='$this->tittamanno' color='$this->titcolor'>";
			echo "$semana[$i]</font></b></td>\n"; 
		}
		echo "</tr> \n"; 


		/*  Imprimimos celdas vacias hasta el dia de la semana del dia uno  */ 
		echo "<tr> \n"; 
		$diasemana = 1;
		while($diasemana < $DiaSemanaPrimerDiaMes)  { 
			echo "<td align='center' bgcolor='$this->numfondo' height='$this->col_alto' width='$this->col_ancho'>&nbsp;</td>\n"; 
			$diasemana  +=  1; 
		} 

		for($dia = 1; $dia  <=  $ultimodia; $dia++)  { 
			
			echo "<td align='center' bgcolor='$this->numfondo' height='$this->col_alto' width='$this->col_ancho'>";
			echo "<font face='$this->numletra' size='$this->numtamanno' color='$this->numcolor'>";

			if ($this->url) {
				$http = $this->url."?anno=$this->anno&mes=$this->mes&dia=$dia";
				if ($this->target) {
					$http .= " target='$this->target'";
				}
			      echo "<a href='$http'>$dia</a></td>\n";	
			} else {
				echo "$dia</font></td>\n"; 
			}

			if ($diasemana  ==  7 AND $dia != $ultimodia)   { 
				echo "</tr>\n<tr>\n"; 
				$diasemana  =  1; 
			} elseif ($diasemana  ==  7) {
				echo "</tr>\n<tr>\n"; 
	        } else {
				$diasemana  +=  1; 
			}
    
		}  

		/*  Completamos la semana con celdas vacias */ 
		if ($diasemana < 7) {
			while($diasemana  <= 7 )  { 
				echo "<td align='center' bgcolor='$this->numfondo' height='$this->col_alto' width='$this->col_ancho'>&nbsp;</td>\n"; 
				$diasemana  +=  1; 
			}
			echo "</tr>\n"; 
		}
		echo "</table>\n"; 
		echo "</div>\n"; 
	
	} //fin clase
}
$cc = new calendario();
//$cc->init(1,2,2000);
$cc->imprimir();
$cc->setUrl("ASF");
$cc->imprimir();
$cc->setNumeros("Arial", "2", "#FFFF00", "#FFFF00");
$cc->imprimir();
$cc->setTabla("right","0");
$cc->imprimir();
$cc->setTabla("center",0,45,55);
$cc->imprimir()
?>  
