/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.webmacro.util.Constant;

public final class Log {
    public static final boolean debug = false;
    private static final Vector logsRegistered = new Vector();
    private static Hashtable logsEnabled = null;
    public static final Constant NONE = new Constant("NONE", 0);
    public static final Constant ERROR = new Constant("ERROR", 1);
    public static final Constant WARNING = new Constant("WARNING", 2);
    public static final Constant INFO = new Constant("INFO", 3);
    public static final Constant EXCEPTION = new Constant("EXCEPTION", 4);
    public static final Constant DEBUG = new Constant("DEBUG", 5);
    public static final Constant ALL = new Constant("ALL", 6);
    private static int myLevel = INFO.getOrder();
    private static PrintWriter myTarget = new PrintWriter(System.out, true);
    private static boolean iTraceExceptions = false;
    private static DateFormat dateFmt = DateFormat.getDateTimeInstance(3, 3);
    private String logType;
    private String logDescr;

    public static final Constant getConstant(int n) {
        Constant constant;
        switch (n) {
            case 0: {
                constant = NONE;
                break;
            }
            case 1: {
                constant = ERROR;
                break;
            }
            case 2: {
                constant = WARNING;
                break;
            }
            case 3: {
                constant = INFO;
                break;
            }
            case 4: {
                constant = EXCEPTION;
                break;
            }
            case 5: {
                constant = DEBUG;
                break;
            }
            case 6: {
                constant = ALL;
                break;
            }
            default: {
                if (n < 0) {
                    constant = NONE;
                    break;
                }
                constant = ALL;
                break;
            }
        }
        return constant;
    }

    public static final Constant getConstant(String string) {
        Constant constant = string.equalsIgnoreCase(NONE.getName()) ? NONE : (string.equalsIgnoreCase(ERROR.getName()) ? ERROR : (string.equalsIgnoreCase(WARNING.getName()) ? WARNING : (string.equalsIgnoreCase(INFO.getName()) ? INFO : (string.equalsIgnoreCase(EXCEPTION.getName()) ? EXCEPTION : (string.equalsIgnoreCase(DEBUG.getName()) ? DEBUG : ALL)))));
        return constant;
    }

    public static final void setLevel(Constant constant) {
        myLevel = constant.getOrder();
        myTarget.println("*** LOG LEVEL SET TO: " + constant);
    }

    public static final void setTarget(PrintWriter printWriter) {
        if (printWriter == null) {
            printWriter = new PrintWriter(new OutputStreamWriter(System.err));
        }
        myTarget = printWriter;
        myTarget.println("*** BEGIN: " + dateFmt.format(new Date()) + "***");
    }

    public static final void setTarget(String string) throws IOException {
        PrintWriter printWriter = string != null ? new PrintWriter(new FileWriter(string, true)) : new PrintWriter(new OutputStreamWriter(System.err));
        Log.setTarget(printWriter);
        printWriter.flush();
    }

    public static final void traceExceptions(boolean bl) {
        iTraceExceptions = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void write(String string, String string2, Object object) {
        try {
            myTarget.print(dateFmt.format(new Date()) + "\t" + string2 + "\t" + string + "\t" + object);
            return;
        }
        catch (Exception exception) {
            System.err.println("** COULD NOT WRITE LOG! SWITCHING TO STDERR **");
            System.err.println(dateFmt.format(new Date()) + "\t" + string + "\t" + object);
            System.err.flush();
            Log.setTarget(new PrintWriter(System.err));
        }
    }

    private static final void writeln(String string, String string2, Object object) {
        Log.write(string, string2, object);
        myTarget.println();
        myTarget.flush();
    }

    public static final Enumeration getTypes() {
        return logsRegistered.elements();
    }

    public static final Enumeration getTypesEnabled() {
        if (logsEnabled == null) {
            return logsRegistered.elements();
        }
        return logsEnabled.elements();
    }

    public static final void logEnable(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n].intern(), "true");
            ++n;
        }
        logsEnabled = hashtable;
    }

    public final void error(Object object) {
        if (myLevel >= ERROR.getOrder()) {
            Log.writeln("ERROR", this.logType, object);
        }
    }

    public final void warning(Object object) {
        if (myLevel >= WARNING.getOrder()) {
            Log.writeln("WARN", this.logType, object);
        }
    }

    public final void info(Object object) {
        if (myLevel >= INFO.getOrder()) {
            Log.writeln("INFO", this.logType, object);
        }
    }

    public final void exception(Object object) {
        if (myLevel < EXCEPTION.getOrder()) {
            return;
        }
        if (iTraceExceptions && object instanceof Exception) {
            Exception exception = (Exception)object;
            Log.write("EXCPT", this.logType, "");
            exception.printStackTrace(myTarget);
            myTarget.flush();
        } else {
            Log.writeln("EXCPT", this.logType, object);
        }
    }

    public final void debug(Object object) {
        if (myLevel >= DEBUG.getOrder()) {
            Log.writeln("DEBUG", this.logType, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        try {
            System.out.println("Logging to \"log\" in the current directory.");
            Log.setTarget("log");
            Log log = new Log("testing", "just used for testing");
            int n = NONE.getOrder();
            while (true) {
                if (n > ALL.getOrder()) {
                    return;
                }
                Log.setLevel(Log.getConstant(n));
                log.error("Testing error");
                log.warning("This is a warning");
                log.info("This is informative.");
                log.exception("An exception");
                log.debug("Debug junk");
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Log(String string, String string2) {
        this.logType = string.intern();
        this.logDescr = string2;
        logsRegistered.addElement(this);
    }
}

