/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import javax.servlet.ServletException;
import org.webmacro.engine.Template;
import org.webmacro.servlet.Handler;
import org.webmacro.servlet.HandlerException;
import org.webmacro.servlet.WMServlet;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.Log;

public final class Reactor
extends WMServlet {
    private static final Log _log = new Log("reactor", "Reactor Servlet");
    private String _errorVariable;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void start() throws ServletException {
        try {
            this._errorVariable = this.getConfig("ErrorVariable");
            return;
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not grab handler or errorVariable from broker");
            throw new ServletException("Cannot initialize critical resources");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Template handle(WebContext webContext) throws HandlerException {
        Handler handler = null;
        String string = webContext.getRequest().getServletPath();
        try {
            handler = this.getHandler(string);
            return handler.accept(webContext);
        }
        catch (Exception exception) {
            _log.exception(exception);
            return this.error(webContext, "Reactor: Unable to create handler for script name: " + string + "... this may be because your handler is not in your CLASSPATH," + " or that you have not registered WebMacro as the handler for " + " the name " + string + " in servlet.properties (or equiv.).");
        }
    }
}

