/*
(C) 1998 Patrick Lambert <drow@fastethernet.net>

This program is free software. You can use, distribute and modify it if
you let this legal note in all future versions, and if the program made
stays under free software. (see sscript.doc)

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

/* This program uses ZLIB by Jean-loup Gailly and Mark Adler available
   from sunsite.unc.edu */

#include "sscript.h"
#ifdef USE_LIBZ
#include <stdio.h>
#include <zlib.h>
#include <malloc.h>

int zip_string(char *string, char *file)
{
 gzFile gfd;
 int len = strlen(string)+1;
 gfd = gzopen(file, "wb");
 if(gfd==NULL) { lasterror=124; return -1; }
 gzwrite(gfd, string, len);
 gzclose(gfd);
}

char *unzip_string(char *file)
{
 gzFile gfd;
 char data[512];
 int len = sizeof(data);
 gfd = gzopen(file, "rb");
 if(gfd==NULL) { lasterror=124; return (char *)"(null)"; }
 gzread(gfd, data, len);
 gzclose(gfd);
 strcpy(queryGlVar,data);
 return (char *)queryGlVar;
}

int unzip_file(char *i, char *o)
{
 gzFile gfd;
 FILE *fd;
 char *data;
 int len = 1000000;
 data = malloc(1000000);
 bzero(data, 1000000);
 gfd = gzopen(i, "rb");
 if(gfd==NULL) { lasterror=124; return -1; }
 gzread(gfd, data, len);
 gzclose(gfd);
 fd = fopen(o, "w");
 fputs(data,fd);
 if(fd!=NULL) fclose(fd);
 free(data);
}

int zip_file(char *i, char *o)
{
 gzFile gfd;
 FILE *fd;
 char *data;
 char string[512];
 int len;
 data = malloc(1000000);
 bzero(data, 1000000);
 fd = fopen(i, "r");
 while(fgets(string,512,fd)!=NULL) strcat(data,string);
 if(fd!=NULL) fclose(fd);
 gfd = gzopen(o, "wb");
 if(gfd==NULL) { lasterror=124; return -1; }
 len = strlen(data)+1;
 gzwrite(gfd, data, len);
 gzclose(gfd);
 free(data);
}
#endif
