/*
(C) 1998 Patrick Lambert <drow@fastethernet.net>

This program is free software. You can use, distribute and modify it if
you let this legal note in all future versions, and if the program made
stays under free software. (see sscript.doc)

This program is distributed without ANY WARRANTY, without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR   
PURPOSE.

Latest version of Socket Script is always available from
http://devplanet.fastethernet.net/sscript.html
*/

#include "sscript.h"
#ifdef RAWLINUX
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <signal.h>
#include <errno.h>
#define RAW_P htons(0x0800)
#include <linux/if.h>
#include <linux/socket.h>
#include <linux/ip.h>  
#include <linux/tcp.h>
#include <linux/if_ether.h>
#include <unistd.h>
#include <netdb.h>   

struct etherpacket {
 struct ethhdr eth;
 struct iphdr ip;
 struct tcphdr tcp;
 char data[8192];
};

raw_linux(char in[1024][512], int type)
{
 /* based on linux sniffer by loq, no copyright or license */
 int rawsock,i,len=0;
 char mytemp[255],mytemp2[255];
 struct ifreq ifaddr;
 struct etherpacket ep;
 struct sockaddr dest;
 struct iphdr *ip;
 struct tcphdr *tcp;
 struct timeval timeout;
 fd_set rd,wr;
 if((rawsock=socket(AF_INET,SOCK_PACKET,RAW_P))<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"SOCKET FAILED: %s",strerror(errno));
  return -1;
 }
 strcpy(ifaddr.ifr_name,lindex(in[atoi(lindex2(temp,1))],0));
 if(ioctl(rawsock,SIOCGIFFLAGS,&ifaddr)<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"CAN'T GET FLAGS: %s",strerror(errno));
  return -1;
 }
 ifaddr.ifr_flags |= IFF_PROMISC;
 if(ioctl(rawsock,SIOCSIFFLAGS,&ifaddr)<0)
 {
  sprintf(in[atoi(lindex(temp,1))],"CAN'T SET FLAGS: %s",strerror(errno));
  return -1;
 }
 if(type)
 {
  for(i=0;i<atoi(lindex(temp,2));i++)
  {
   /* there should be an easier way to do this... */
   bzero(&dest,sizeof(dest));
   FD_ZERO(&rd);
   FD_ZERO(&wr);
   FD_SET(rawsock,&rd);
   timeout.tv_sec=0;
   timeout.tv_usec=0;
   ip=(struct iphdr *)(((unsigned long)&ep.ip)-2);
   tcp=(struct tcphdr *)(((unsigned long)&ep.tcp)-2);
   while(timeout.tv_sec==0 && timeout.tv_usec==0)
   {
    timeout.tv_sec=10;
    timeout.tv_usec=0;
    select(20,&rd,&wr,NULL,&timeout);
    if(FD_ISSET(rawsock,&rd))
    {
     recvfrom(rawsock,&ep,sizeof(ep),0,&dest,&len);
    }
   }
   sprintf(mytemp,"%s %d -> ",inet_ntoa(ip->saddr),ntohs(tcp->source));
   sprintf(mytemp2,"%s %d ;",inet_ntoa(ip->daddr),ntohs(tcp->dest));
   sprintf(in[atoi(lindex(temp,3))],"%s%s",mytemp,mytemp2);
  }
  close(rawsock);
 }
 else
 {
  for(i=0;i<atoi(lindex(temp,2));i++)
  {
   /* there should be an easier way to do this... */
   bzero(&dest,sizeof(dest));
   FD_ZERO(&rd);
   FD_ZERO(&wr);
   FD_SET(rawsock,&rd);
   timeout.tv_sec=0;
   timeout.tv_usec=0;
   ip=(struct iphdr *)(((unsigned long)&ep.ip)-2);
   tcp=(struct tcphdr *)(((unsigned long)&ep.tcp)-2);
   while(timeout.tv_sec==0 && timeout.tv_usec==0)
   {
    timeout.tv_sec=10;
    timeout.tv_usec=0;
    select(20,&rd,&wr,NULL,&timeout);
    if(FD_ISSET(rawsock,&rd))
    {
     recvfrom(rawsock,&ep,sizeof(ep),0,&dest,&len);
    }
   }
   sprintf(mytemp,"%s[%d] -> ",inet_ntoa(ip->saddr),ntohs(tcp->source));
   printf("%s",mytemp);
   sprintf(mytemp,"%s[%d]\n",inet_ntoa(ip->daddr),ntohs(tcp->dest));
   printf("%s",mytemp);
  }
  close(rawsock);
 }
}
#endif
