.PHONY: install-doc install-dvi uninstall-doc uninstall-dvi

install-doc:
ifneq (,$(TEXINFO))
	$(INSTALL) -d $(PREFIX)/info
	for PAGE in $(TEXINFO); do \
	    makeinfo -o $(PREFIX)/info/`basename $$PAGE .texi`.info $$PAGE; \
	done
endif

install-dvi:
ifneq (,$(TEXINFO))
	$(INSTALL) -d $(PREFIX)/doc
	for PAGE in $(TEXINFO); do \
            X=`basename $$PAGE .texi`; \
            texi2dvi $$PAGE; \
            $(INSTALL) $$X.dvi $(PREFIX)/doc; \
            rm -f $$X.?? $$X.??s $$X.aux $$X.log $$X.toc $$X.dvi; \
        done;
endif

uninstall-doc:
ifneq (,$(TEXINFO))
	for PAGE in $(TEXINFO); do \
	    rm -f $(PREFIX)/info/`basename $$PAGE .texi`.info*; \
	done
endif

uninstall-dvi:
ifneq (,$(TEXINFO))
	for PAGE in $(TEXINFO); do \
	    rm -f $(PREFIX)/doc/`basename $$PAGE .texi`.dvi; \
	done
endif
