.PHONY: depend

# hide local-max_home in &
ifdef LOCAL_MAX_HOME
POSTPROCESS += -e "s@$(subst .,\.,$(LOCAL_MAX_HOME))@\&@g"
endif

# hide max-home in %
POSTPROCESS = -e "s@$(subst .,\.,$(MAX_HOME))@\%@g"

# remove remaining absolute pathes
POSTPROCESS += -e "s@ /[-+_./a-zA-Z0-9]*@@g"

# remove empty rules
POSTPROCESS += -e "s@^.*: *\$$@@"

# exchange the target - add the directory etc.
POSTPROCESS += -e "s@[^ ].*:@$$\(SYSTEM\)\/&@"

# expand % to the max-home macro
POSTPROCESS += -e "s@\%@$$\(MAX_HOME\)@g"

# expand % to the local-max-home macro
ifdef LOCAL_MAX_HOME
POSTPROCESS += -e "s@\&@$$\(LOCAL_MAX_HOME\)@g"
endif

# smart style - everything automatically
depend:
	rm -f .depend
ifneq (,$(CFILES))
ifeq ($(CC_HAS_M),YES)
	$(CC) -M $(ALL_CFLAGS) $(CFILES) >.depend.tmp
	sed $(POSTPROCESS) <.depend.tmp >.depend
else
ifneq (,$(MAKEDEPEND))
	rm -f .depend.tmp; touch .depend.tmp
	makedepend -f .depend.tmp $(INC_FLAGS) $(CFILES) 2>/dev/null
	sed $(POSTPROCESS) <.depend.tmp >.depend
else
	@echo "can't detect dependencies"
	@false
endif # MAKEDEPEND
endif # CC_HAS_M
endif # CFILES

	rm -f .depend.tmp* .depend.err

-include .depend
