.PHONY:

OBJECTS =
OBJECTS +=	$(patsubst %.c,$(SYSTEM)/%.o,$(CFILES))

ifneq ($(USE_SHARED),YES)
override CC_SO_FLAGS = 
endif

INC_FLAGS =

# set include pathes
ifdef LOCAL_MAX_HOME
INC_FLAGS +=	-I$(LOCAL_MAX_HOME)/include
endif
INC_FLAGS +=	-I$(MAX_HOME)/include
INC_FLAGS +=	$(foreach X,$(ADD_INC_DIR),-I$(X))
INC_FLAGS +=	$(EXTERNAL_INCLUDES)

# compose the flags
ALL_CFLAGS =	$(INC_FLAGS) $(CC_SO_FLAGS) $(CC_SYS_FLAGS) \
		$(EXTERNAL_FLAGS) $(MAX_FLAGS) $(CC_COMPAT_FLAGS) \
		$(CFLAGS) $(ADD_CFLAGS)

.PRECIOUS: $(SYSTEM)/.system depend/.system

$(SYSTEM)/%.o: %.c $(SYSTEM)/.system
	$(CC) $(ALL_CFLAGS) -o $@ -c $<


%/.system:
	mkdir -p $*
	touch $@
