.PHONY: all $(NAME) apps install uninstall

TARGET=$(SYSTEM)/$(NAME)

include $(MAX_HOME)/rules/init.mk
include $(MAX_HOME)/rules/compile.mk
include $(MAX_HOME)/rules/needs.mk

LIBS =          $(MAX_LIB_DIRS) $(ADD_MAX_LIB) $(MAX_LIBS) \
                $(ADD_EXTERNAL_LIB) $(EXTERNAL_LIBS)


ifndef CC_LD
CC_LD = $(CC)
endif


ifneq ($(FAILURE),YES)
$(TARGET): $(ADD_TARGET) $(OBJECTS)
	$(CC_LD) -o $@ $(OBJECTS) $(LIB_FLAGS) $(LIBS)
endif

install: install-bin install-doc

install-bin: $(ADD_INSTALL) $(TARGET)
	$(INSTALL) -d $(PREFIX)/bin
	$(INSTALL) -s $(SYSTEM)/$(NAME) $(PREFIX)/bin

uninstall: uninstall-bin uninstall-doc

uninstall-bin: $(ADD_UNINSTALL)
	rm -f $(PREFIX)/bin/$(NAME)

all $(NAME) apps: $(TARGET)

include $(MAX_HOME)/rules/doc.mk
include $(MAX_HOME)/rules/depend.mk
include $(MAX_HOME)/rules/clean.mk
