/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

%{
#include "main.h"
%}

%token TK_ALIAS
%token TK_APPLICATION
%token TK_CXX_SUFFIX
%token TK_DEPEND
%token TK_EOF
%token TK_FILE
%token TK_IDENT
%token TK_INCLUDE
%token TK_PROJECT
%token TK_PROGRAM
%token TK_LANGUAGE
%token TK_LIB
%token TK_LIBRARY
%token TK_LIKES
%token TK_MANUAL
%token TK_MODULE
%token TK_NEAR
%token TK_NEEDS
%token TK_NAME
%token TK_PRIVATE
%token TK_REPLACES
%token TK_VERSION

%%

ALL:		  DEFINITIONS { YYACCEPT; };

DEFINITIONS:	  /* nothing */ | DEFINITION DEFINITIONS ;

DEFINITION:	  PROJECT | LIBRARY | PROGRAM | MODULE | APPLICATION;

PROJECT:	  TK_PROJECT TK_IDENT { project_create (); } PROJECT_DEFS
		  { project_end (); };
PROJECT_DEFS:	  /* nothing */ | PROJECT_DEF PROJECT_DEFS;
PROJECT_DEF:	  TK_VERSION  TK_IDENT { project_set_version (); }
		| TK_LANGUAGE { ident_set_handler (project_add_language); } TK_IDENTS
		| TK_DEPEND TK_IDENT { project_set_depend (); }
		| TK_CXX_SUFFIX TK_IDENT { project_set_cxx_suffix (); }
		| TK_MANUAL { ident_set_handler (project_add_manual); } TK_IDENTS;

LIBRARY:	  TK_LIBRARY TK_IDENT { library_create (yytext); } LIBRARY_DEFS
		  { library_end (); };
LIBRARY_DEFS:	  /* nothing */ | LIBRARY_DEF LIBRARY_DEFS;
LIBRARY_DEF:	  TK_REPLACES TK_IDENT { library_set_replace (); }
		| TK_LIB { ident_set_handler (library_add_lib); } TK_IDENTS
		| TK_NEEDS { ident_set_handler (library_add_need); } TK_IDENTS
		| TK_INCLUDE TK_IDENT { library_set_include (); }
		| TK_NEAR { ident_set_handler (library_add_near); } TK_IDENTS;

PROGRAM:	  TK_PROGRAM TK_IDENT { program_create (); } PROGRAM_DEFS
		  { program_end (); };
PROGRAM_DEFS:	  /* nothing */ | PROGRAM_DEF PROGRAM_DEFS;
PROGRAM_DEF:	  TK_REPLACES TK_IDENT { program_set_replace (); }
		| TK_FILE TK_IDENT { program_set_file (); }
		| TK_NEAR { ident_set_handler (program_add_near); } TK_IDENTS;

MODULE:		  TK_MODULE TK_IDENT { module_create (); } MODULE_DEFS
		  { module_end (); };
MODULE_DEFS:	  /* nothing */ | MODULE_DEF MODULE_DEFS;
MODULE_DEF:	  TK_ALIAS TK_IDENT { module_set_alias (); };
		| TK_PRIVATE { module_set_private (); }
		| TK_NEEDS { ident_set_handler (module_add_need); } TK_IDENTS
		| TK_LIKES { ident_set_handler (module_add_like); } TK_IDENTS;

APPLICATION:	  TK_APPLICATION TK_IDENT { application_create (); }
		  APPLICATION_DEFS { application_end (); };
APPLICATION_DEFS:  /* nothing */ | APPLICATION_DEF APPLICATION_DEFS;
APPLICATION_DEF:  TK_NEEDS { ident_set_handler (application_add_need); } TK_IDENTS
		| TK_LIKES { ident_set_handler (application_add_like); } TK_IDENTS;

TK_IDENTS:	  /* nothing */ | TK_IDENT { ident_insert (); } TK_IDENTS;
