/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _MAIN_H
#define _MAIN_H

#include <stdio.h>

extern FILE *yyin;
extern int yylineno;
extern char yytext[];

extern void ident_set_handler (void (*)());
extern void (*ident_insert) ();

extern void application_create ();
extern void application_add_like ();
extern void application_add_need ();
extern void application_end ();

extern void library_create (char *name);
extern void library_add_lib ();
extern void library_add_near ();
extern void library_add_need ();
extern void library_set_include ();
extern void library_set_replace ();
extern void library_end ();

extern void module_create ();
extern void module_add_like ();
extern void module_add_need ();
extern void module_set_alias ();
extern void module_set_prefix ();
extern void module_set_private ();
extern void module_end ();

extern void project_create ();
extern void project_add_manual ();
extern void project_add_language ();
extern void project_set_cxx_suffix ();
extern void project_set_depend ();
extern void project_set_version ();
extern void project_end ();

extern void program_create ();
extern void program_add_near ();
extern void program_set_replace ();
extern void program_set_file ();
extern void program_set_version ();
extern void program_end ();

extern void yyerror (const char*);
extern int yylex ();
extern int yyparse ();
extern void yyrestart (FILE *);
extern int yywrap ();

#endif
