.PHONY: libs install install-bin install-doc uninstall uninstall-bin \
        uninstall-doc

ifeq ($(SHARED_LIBS),YES)
TARGET=$(LIB_DIR)/lib$(NAME).so.$(VERSION)
else
TARGET=$(LIB_DIR)/lib$(NAME).a
endif

include $(PROJECT_HOME)/rules/init.mk

ifeq ($(SHARED_LIBS),YES)
USE_SHARED = YES
endif

include $(PROJECT_HOME)/rules/compile.mk
include $(PROJECT_HOME)/rules/needs.mk

ifeq ($(SHARED_LIBS),YES)
libs: $(ADD_TARGET) $(LIB_DIR)/.system $(LIB_DIR)/lib$(NAME).so
else
libs: $(ADD_TARGET) $(LIB_DIR)/.system $(LIB_DIR)/lib$(NAME).a
endif

$(LIB_DIR)/lib$(NAME).so: $(LIB_DIR)/lib$(NAME).so.$(VERSION_MAJOR)
	rm -f $@
	$(LN_S) lib$(NAME).so.$(VERSION_MAJOR) $@

$(LIB_DIR)/lib$(NAME).so.$(VERSION_MAJOR): $(LIB_DIR)/lib$(NAME).so.$(VERSION)
	rm -f $@
	$(LN_S) lib$(NAME).so.$(VERSION) $@

@if c++
ifndef CXX_LD
CXX_LD = $(CXX)
endif
@end

@if c
ifndef CC_LD
CC_LD = $(CC)
endif
@end

ifneq ($(FAILURE),YES)
$(LIB_DIR)/lib$(NAME).so.$(VERSION): $(OBJECTS)
@if c++
	$(CXX_LD) $(CXX_SL_FLAGS) -o lib$(NAME).so.$(VERSION) $(OBJECTS) $(TEMPLATES)
@else
@if c
	$(CC_LD) $(CC_SL_FLAGS) -o lib$(NAME).so.$(VERSION) $(OBJECTS) $(TEMPLATES)
@end
@end
	mv -f lib$(NAME).so.$(VERSION) $@
endif

ifneq ($(FAILURE),YES)
$(LIB_DIR)/lib$(NAME).a: $(OBJECTS)
	ar cr $@ $(OBJECTS) $(TEMPLATE_OBJECTS)
	$(RANLIB) $@
endif

$(LIB_DIR)/.system:
	mkdir -p $(LIB_DIR)
	touch $@

install: install-bin install-doc

uninstall: uninstall-bin uninstall-doc

ifeq ($(SHARED_LIBS),YES)
FULL_NAME = lib$(NAME).so
SOURCE = $(LIB_DIR)/$(FULL_NAME)
TARGET = $(PREFIX)/lib/$(FULL_NAME)
install-bin: libs
	mkdir -p $(PREFIX)/lib
	cp $(SOURCE).$(VERSION) $(TARGET).$(VERSION)
	rm -f $(TARGET).$(VERSION_MAJOR)
	$(LN_S) $(FULL_NAME).$(VERSION) $(TARGET).$(VERSION_MAJOR)
	rm -f $(TARGET)
	$(LN_S) $(FULL_NAME).$(VERSION_MAJOR) $(TARGET)
	mkdir -p $(PREFIX)/include
	cp -fr $(PROJECT_HOME)/include/$(ALIAS) $(PREFIX)/include
 
uninstall-bin:
	rm -f $(TARGET).$(VERSION)
	rm -f $(TARGET).$(VERSION_MAJOR)
	rm -f $(TARGET)
	rm -fr $(PREFIX)/include/$(ALIAS)
 
else
ifneq ($(HIDDEN),YES)
FULL_NAME = lib$(NAME).a
SOURCE = $(LIB_DIR)/$(FULL_NAME)
TARGET = $(PREFIX)/lib/$(FULL_NAME)
install-bin: libs
	mkdir -p $(PREFIX)/lib
	cp -f $(SOURCE) $(TARGET)
	mkdir -p $(PREFIX)/include
	cp -fr $(PROJECT_HOME)/include/$(ALIAS) $(PREFIX)/include
 
uninstall-bin:
	rm -f $(TARGET)
	rm -fr $(PREFIX)/include/$(ALIAS)
else
install-bin uninstall-bin:

endif
endif

include $(PROJECT_HOME)/rules/doc.mk
include $(PROJECT_HOME)/rules/depend.mk
include $(PROJECT_HOME)/rules/clean.mk
