.PHONY: install-doc install-dvi uninstall-doc uninstall-dvi

install-doc:
@if man
ifneq (,$(MAN))
	for PAGE in $(MAN); do \
	    FOLDER=`echo $$PAGE | sed -e "s@[^.]*\.@@"`; \
	    $(INSTALL) -d $(PREFIX)/man/man$$FOLDER; \
	    $(INSTALL) $$PAGE $(PREFIX)/man/man$$FOLDER; \
	done
endif
@end
@if texinfo
ifneq (,$(TEXINFO))
	$(INSTALL) -d $(PREFIX)/info
	for PAGE in $(TEXINFO); do \
	    makeinfo -o $(PREFIX)/info/`basename $$PAGE .texi`.info $$PAGE; \
	done
endif
@end
@if doc
ifneq (,$(DOC))
	$(INSTALL) -d $(PREFIX)/doc/project
	for X in $(DOC); do \
	    cp -r $$X $(PREFIX)/doc/project; \
	done
endif
@end

@if texinfo
install-dvi:
ifneq (,$(TEXINFO))
	$(INSTALL) -d $(PREFIX)/doc
	for PAGE in $(TEXINFO); do \
            X=`basename $$PAGE .texi`; \
            texi2dvi $$PAGE; \
            $(INSTALL) $$X.dvi $(PREFIX)/doc; \
            rm -f $$X.?? $$X.??s $$X.aux $$X.log $$X.toc $$X.dvi; \
        done;
endif
@end

uninstall-doc:
@if man
ifneq (,$(MAN))
	for PAGE in $(MAN); do \
	    FOLDER=`echo $$PAGE | sed -e "s@[^.]*\.@@"`; \
	    rm -f $$PAGE $(PREFIX)/man/man$$FOLDER/$$PAGE; \
	done
endif
@end
@if texinfo
ifneq (,$(TEXINFO))
	for PAGE in $(TEXINFO); do \
	    rm -f $(PREFIX)/info/`basename $$PAGE .texi`.info*; \
	done
endif
@end
@if doc
ifneq (,$(DOC))
	$(INSTALL) -d $(PREFIX)/doc/project
	for X in $(DOC); do \
	    rm -fr $(PREFIX)/doc/project/$$X; \
	done
endif
@end

@if texinfo
uninstall-dvi:
ifneq (,$(TEXINFO))
	for PAGE in $(TEXINFO); do \
	    rm -f $(PREFIX)/doc/`basename $$PAGE .texi`.dvi; \
	done
endif
@end
