.PHONY: depend

# hide local-project_home in &
ifdef LOCAL_PROJECT_HOME
POSTPROCESS += -e "s@$(subst .,\.,$(LOCAL_PROJECT_HOME))@\&@g"
endif

# hide project-home in %
POSTPROCESS = -e "s@$(subst .,\.,$(PROJECT_HOME))@\%@g"

# remove remaining absolute pathes
POSTPROCESS += -e "s@ /[-+_./a-zA-Z0-9]*@@g"

# remove empty rules
POSTPROCESS += -e "s@^.*: *\$$@@"

# exchange the target - add the directory etc.
@if smart
POSTPROCESS += -e "s@[^ ].*:@$@:@"
@else
POSTPROCESS += -e "s@[^ ].*:@$$\(SYSTEM\)\/&@"
@end

# expand % to the project-home macro
POSTPROCESS += -e "s@\%@$$\(PROJECT_HOME\)@g"

# expand % to the local-project-home macro
ifdef LOCAL_PROJECT_HOME
POSTPROCESS += -e "s@\&@$$\(LOCAL_PROJECT_HOME\)@g"
endif

# smart style - everything automatically
@if smart

# include the dependency-files
EXISTING_DEP_FILES = $(wildcard depend/*.d)
ifneq (,$(EXISTING_DEP_FILES))
-include $(EXISTING_DEP_FILES)
endif

@if c
.PRECIOUS: $(subst .c,.d,$(foreach FILE,$(CFILES),depend/$(FILE)))
@end
@if c++
.PRECIOUS: $(subst .CXXSUFFIX,.d,$(foreach FILE,$(CXXFILES),depend/$(FILE)))
@end

depend/%.d: %.c depend/.system
ifeq ($(CC_HAS_M),YES)
	$(CC) -M $(ALL_CFLAGS) $< | sed $(POSTPROCESS) > $@
else
ifneq (,$(MAKEDEPEND))
	rm -f $@*; touch $@.tmp
	makedepend -f $@.tmp $(INC_FLAGS) $< 2>/dev/null
	sed $(POSTPROCESS) <$@.tmp >$@
	rm -f $@.tmp*
endif
endif

depend/%.d: %.CXXSUFFIX depend/.system
ifeq ($(CXX_HAS_M),YES)
	$(CXX) -M $(ALL_CXXFLAGS) $< | sed $(POSTPROCESS) > $@
else
	rm -f $@*; touch $@.tmp
	makedepend -D__cplusplus -f $@.tmp $(INC_FLAGS) $< 2>$@.err
	sed $(POSTPROCESS) <$@.tmp >$@.tmp2
	eval sed `grep "not in [a-z]" < $@.err | \
	  sed -e "s@.*not in @@" -e "s@^@-e \"s\@@" -e "s@\$$@\@\@g\"@" |
	  tr "\012" " "` <$@.tmp2 >$@
	rm -f $@.tmp* $@.err
endif

# traditional style - make depend on request
@else
depend:
	rm -f .depend
@if c
ifneq (,$(CFILES))
ifeq ($(CC_HAS_M),YES)
	$(CC) -M $(ALL_CFLAGS) $(CFILES) >.depend.tmp
	sed $(POSTPROCESS) <.depend.tmp >.depend
else
ifneq (,$(MAKEDEPEND))
	rm -f .depend.tmp; touch .depend.tmp
	makedepend -f .depend.tmp $(INC_FLAGS) $(CFILES) 2>/dev/null
	sed $(POSTPROCESS) <.depend.tmp >.depend
else
	@echo "can't detect dependencies"
	@false
endif # MAKEDEPEND
endif # CC_HAS_M
endif # CFILES
@end

@if c++
ifneq (,$(CXXFILES))
ifeq ($(CXX_HAS_M),YES)
	$(CXX) -M $(ALL_CXXFLAGS) $(CXXFILES) >.depend.tmp
	sed $(POSTPROCESS) <.depend.tmp >.depend
else
ifneq (,$(MAKEDEPEND))
	rm -f .depend.tmp; touch .depend.tmp
	makedepend -D__cplusplus -f .depend.tmp $(INC_FLAGS) $(CXXFILES) \
	  2>.depend.err
	sed $(POSTPROCESS) \
	  <.depend.tmp >.depend.tmp2
	eval sed `grep "not in [a-z]" < .depend.err | \
	  sed -e "s@.*not in @@" -e "s@^@-e \"s\@@" -e "s@\$$@\@\@g\"@" |
	  tr "\012" " "` < .depend.tmp2 >.depend
	$(PROJECT_HOME)/scripts/fixdepend
else
	@echo "can't detect dependencies"
	@false
endif # MAKEDEPEND
endif # CXX_HAS_M
endif # CXXFILES
@end
	rm -f .depend.tmp* .depend.err

-include .depend
@end
