.PHONY:

OBJECTS =
@if c
OBJECTS +=	$(patsubst %.c,$(SYSTEM)/%.o,$(CFILES))
@end
@if c++
OBJECTS +=	$(patsubst %.CXXSUFFIX,$(SYSTEM)/%.o,$(CXXFILES))
@end

ifneq ($(USE_SHARED),YES)
@if c
override CC_SO_FLAGS = 
@end
@if c++
override CXX_SO_FLAGS =
@end
endif

INC_FLAGS =

# set include pathes
ifdef LOCAL_PROJECT_HOME
INC_FLAGS +=	-I$(LOCAL_PROJECT_HOME)/include
endif
INC_FLAGS +=	-I$(PROJECT_HOME)/include
INC_FLAGS +=	$(foreach X,$(ADD_INC_DIR),-I$(X))
INC_FLAGS +=	$(EXTERNAL_INCLUDES)

# compose the flags
@if c
ALL_CFLAGS =	$(INC_FLAGS) $(CC_SO_FLAGS) $(CC_SYS_FLAGS) \
		$(EXTERNAL_FLAGS) $(PROJECT_FLAGS) $(CC_COMPAT_FLAGS) \
		$(CFLAGS) $(ADD_CFLAGS)
@end
@if c++
ALL_CXXFLAGS =	$(INC_FLAGS) $(CXX_SO_FLAGS) $(CXX_SYS_FLAGS) \
		$(EXTERNAL_FLAGS) $(PROJECT_FLAGS) $(CXX_COMPAT_FLAGS) \
		$(CXXFLAGS) $(ADD_CXXFLAGS)
@end

.PRECIOUS: $(SYSTEM)/.system depend/.system

@if c
@if smart
$(SYSTEM)/%.o: %.c depend/%.d $(SYSTEM)/.system
@else
$(SYSTEM)/%.o: %.c $(SYSTEM)/.system
@end
	$(CC) $(ALL_CFLAGS) -o $@ -c $<
@end

@if c++
@if smart
$(SYSTEM)/%.o: %.CXXSUFFIX depend/%.d $(SYSTEM)/.system
@else
$(SYSTEM)/%.o: %.CXXSUFFIX $(SYSTEM)/.system
@end
	$(CXX) $(ALL_CXXFLAGS) -o $@ -c $<
@end

%/.system:
	mkdir -p $*
	touch $@
