.PHONY: all $(NAME) apps install uninstall

TARGET=$(SYSTEM)/$(NAME)

include $(PROJECT_HOME)/rules/init.mk
include $(PROJECT_HOME)/rules/compile.mk
include $(PROJECT_HOME)/rules/needs.mk

LIBS =          $(PROJECT_LIB_DIRS) $(ADD_PROJECT_LIB) $(PROJECT_LIBS) \
                $(ADD_EXTERNAL_LIB) $(EXTERNAL_LIBS)

@if c++
TEMPLATE_OBJECTS = $(wildcard $(TEMPLATES))
@end

@if c
ifndef CC_LD
CC_LD = $(CC)
endif
@end

@if c++
ifndef CXX_LD
CXX_LD = $(CXX)
endif
@end

ifneq ($(FAILURE),YES)
$(TARGET): $(ADD_TARGET) $(OBJECTS)
@if c++
	$(CXX_LD) -o $@ $(OBJECTS) $(TEMPLATES) $(LIB_FLAGS) $(LIBS)
@else
	$(CC_LD) -o $@ $(OBJECTS) $(LIB_FLAGS) $(LIBS)
@end
endif

install: install-bin install-doc

install-bin: $(ADD_INSTALL) $(TARGET)
	$(INSTALL) -d $(PREFIX)/bin
	$(INSTALL) -s $(SYSTEM)/$(NAME) $(PREFIX)/bin

uninstall: uninstall-bin uninstall-doc

uninstall-bin: $(ADD_UNINSTALL)
	rm -f $(PREFIX)/bin/$(NAME)

all $(NAME) apps: $(TARGET)

include $(PROJECT_HOME)/rules/doc.mk
include $(PROJECT_HOME)/rules/depend.mk
include $(PROJECT_HOME)/rules/clean.mk
