/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

%{
#include "parser.h"
%}
SPACE		[ \n\t]+
NEWLINE		#[^\n]*\n|\n
IDENT		[-+./_a-zA-Z0-9]*

%%

{SPACE}		{ ; }
{NEWLINE}	{ yylineno++; };
alias		{ return TK_ALIAS; }
application	{ return TK_APPLICATION; }
c\+\+-suffix	{ return TK_CXX_SUFFIX; }
dependency	{ return TK_DEPEND; }
end		{ return TK_EOF; }
file		{ return TK_FILE; }
includes	{ return TK_INCLUDE; }
project		{ return TK_PROJECT; }
program		{ return TK_PROGRAM; }
language	{ return TK_LANGUAGE; }
libs		{ return TK_LIB; }
library		{ return TK_LIBRARY; }
likes		{ return TK_LIKES; }
manual		{ return TK_MANUAL; }
module		{ return TK_MODULE; }
name		{ return TK_NAME; }
near		{ return TK_NEAR; }
needs		{ return TK_NEEDS; }
replaces	{ return TK_REPLACES; }
private		{ return TK_PRIVATE; }
version		{ return TK_VERSION; }
{IDENT}		{ return TK_IDENT; }
