/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "xtoto/stack.h"
#include "xtoto/xtoto.h"

typedef struct STACK_NODE {
    struct STACK_NODE *next;
    void *data;
} STACK_NODE;

typedef struct STACK {
    STACK_NODE *top;
    int size;
} STACK;

/* create a new stack */
extern STACK *stack_create () {
    STACK *stack;
    stack = (STACK*) safe_malloc (sizeof (STACK));
    stack->top = 0;
    stack->size = 0;
    return stack;
}

/* remove and free the whole stack */
extern void stack_destroy_all (STACK *stack, void (*crush) (void*)) {
    STACK_NODE *this, *next;
    for (this=stack->top; this; this=next) {
	next = this->next;
	crush (this->data);
	safe_free (this);
    }
    safe_free (stack);
}

/* remove and free the top element */
extern void stack_destroy (STACK *stack, void (*crush) (void*)) {
    STACK_NODE *next=stack->top->next;
    crush (stack->top->data);
    safe_free (stack->top);
    stack->top = next;
    stack->size--;
}

/* tell if the stack is empty */
extern int stack_get_size (STACK *stack) {
    return stack->size;
}

/* return and unlink the top element */
extern void *stack_pop (STACK *stack) {
    STACK_NODE *next;
    void *data;

    data = stack->top->data;
    next = stack->top->next;
    safe_free (stack->top);
    stack->top = next;
    stack->size--;
    return data;
}

/* push a new element onto the stack */
extern void stack_push (STACK *stack, void *data) {
    STACK_NODE *new = (STACK_NODE*) safe_malloc (sizeof (STACK_NODE));
    new->data = data;
    new->next = stack->top;
    stack->top = new;
    stack->size++;
}

/* return the top element */
extern void *stack_top (STACK *stack) {
    if (stack->top)
        return stack->top->data;
    return (void*)0;
}

/* remove all elements */
extern void stack_unlink_all (STACK *stack) {
    STACK_NODE *this, *next;
    for (this=stack->top; this; this=next) {
	next = this->next;
	safe_free (this);
    }
    safe_free (stack);
}

/* remove the top element */
extern void stack_unlink (STACK *stack) {
    STACK_NODE *next;
    next = stack->top->next;
    safe_free (stack->top);
    stack->top = next;
    stack->size--;
}
