/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "xtoto/listx.h"
#include "xtoto/xtoto.h"

typedef struct LISTX {
    void *data;
    struct LISTX *next;
} LISTX;

LISTX *listx_destroy (LISTX *list, void *data, void (*crush) (void*)) {
    crush (data);
    return listx_unlink (list, data);
}

void listx_destroy_all (LISTX *list, void (*crush) (void *)) {
    LISTX *this, *next;
    for (this=list; this; this=next) {
        next = this->next;
        crush (this->data);
        safe_free (this);
    }
}

int listx_has (LISTX *list, const void *data) {
    LISTX *this;
    for (this=list; this; this=this->next) {
        if (this->data == data)
            return 1;
    }
    return 0;
}

LISTX *listx_insert (LISTX *list, void *data) {
    LISTX *new = (LISTX*) safe_malloc (sizeof (LISTX));
    new->next = list;
    new->data = data;
    return new;
}

void listx_iterate (LISTX *list, void (*func)(void *, void *), void *misc) {
    LISTX *this;
    for (this=list; this; this=this->next) {
        func (this->data, misc);
    }
}

void *listx_search (LISTX *list, const void *data, int (*comp) (const void *, const void *)) {
    LISTX *this;
    for (this=list; this; this=this->next) {
        if (comp (this->data, data))
            return this->data;
    }
    return (void*)0;
}

LISTX *listx_unlink (LISTX *list, const void *data) {
    LISTX *this, *head, **ptr;
    for (this=head=list,ptr=&head; this; this=*ptr) {
        if (this->data == data) {
            *ptr = this->next;
            safe_free (this);
        } else
            ptr = &this->next;
    }
    return head;
}

void listx_unlink_all (LISTX *list) {
    LISTX *this, *next;
    for (this=list; this; this=next) {
        next = this->next;
        safe_free (this);
    }
}
