/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XTOTO_H
#define _XTOTO_H

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef MAX
#define MAX(X,Y) ((X)>(Y)?(X):(Y))
#endif

#ifndef MIN
#define MIN(X,Y) ((X)<(Y)?(X):(Y))
#endif

#define GNU_PUBLIC_LICENSE \
"\n" \
"This program is free software; you can redistribute it and/or\n" \
"modify it under the terms of the GNU General Public License\n" \
"as published by the Free Software Foundation; either version 2\n" \
"of the License, or (at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program; if not, write to the Free Software Foundation,\n" \
"Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n" \
"\n"

extern const char *HELP;
extern const char *NAME;
extern const char *VERSION;
extern const char *LICENSE;

#define SIMPLE_PROGRAM \
    const char *HELP = 0; \
    const char *NAME = 0; \
    const char *VERSION = 0; \
    const char *LICENSE = 0; \
    void shut_down () { }

extern int debug;
extern int verbose;

extern void error (const char *, ...);
extern void verror (const char *, va_list);
extern void shut_down ();

extern void *safe_malloc (size_t);
extern void *safe_realloc (void *, size_t);
extern char *safe_strdup (const char *);
extern char *safe_strcat (const char *, ...);
extern char *safe_strdupu (char *);
extern void safe_free (void *);

extern char *safe_input (FILE *, int);
extern char *safe_load (const char *, int);
extern FILE *safe_fopen (const char *, const char *);
extern int safe_fread (void *, size_t, size_t, FILE *);
extern int safe_fwrite (void *, size_t, size_t, FILE *);
extern void safe_mkdir (const char *name, int mode);

extern void init ();
extern void show_help ();
extern void show_license ();
extern void show_version ();

extern void verbose_printf (const char *, ...);
extern void debug_printf (const char *, ...);

#endif
