/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XTOTO_STACK_H
#define _XTOTO_STACK_H

struct STACK;

extern struct STACK *stack_create ();
extern void stack_destroy (struct STACK *, void (*)(void*));
extern void stack_destroy_all (struct STACK *, void (*)(void*));
extern int stack_get_size (struct STACK *);
extern void *stack_pop (struct STACK *);
extern void stack_push (struct STACK *, void *);
extern void *stack_top (struct STACK *);
extern void stack_unlink (struct STACK *);
extern void stack_unlink_all (struct STACK *);

#endif
