/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XTOTO_LISTX_H
#define _XTOTO_LISTX_H

struct LISTX;

extern struct LISTX *listx_destroy (struct LISTX *list, void *data, void (*crush) (void *));
extern void listx_destroy_all (struct LISTX *, void (*crush) (void *));
extern int listx_has (struct LISTX *, const void *data);
extern struct LISTX *listx_insert (struct LISTX *list, void *data);
extern void listx_iterate (struct LISTX *list, void (*func)(void *, void *), void *misc);
extern void *listx_search (struct LISTX *, const void *data, int (*)(const void *, const void *));
extern struct LISTX *listx_unlink (struct LISTX *list, void const *data);
extern void listx_unlink_all (struct LISTX *);

#endif
