/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XTOTO_LIST_H
#define _XTOTO_LIST_H

struct LIST;
struct LIST_ITERATOR;

extern void list_append (struct LIST *list, void *data);
extern struct LIST *list_create ();
extern void list_destroy (struct LIST *list, void *data, void (*crush) (void *));
extern void list_destroy_all (struct LIST *, void (*crush) (void *));
extern struct LIST *list_duplicate (struct LIST *);
extern struct LIST *list_flip (struct LIST *);
extern int list_get_size (struct LIST *);
extern int list_has (struct LIST *, const void *data);
extern void list_insert (struct LIST *list, void *data);
extern int list_is_empty (struct LIST *);
extern void list_iterate (struct LIST *, void (*func)(void *, void *), void *misc);
extern void *list_search (struct LIST *, const void *data, int (*)(const void *, const void *));
extern void list_unlink (struct LIST *, const void *data);
extern void list_unlink_all (struct LIST *);

extern struct LIST_ITERATOR *list_iterator_create ();
extern void list_iterator_destroy (struct LIST_ITERATOR *);
extern void list_iterator_reset (struct LIST_ITERATOR *, struct LIST *);
extern void *list_get_next (struct LIST_ITERATOR *);

#endif
