/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XTOTO_HASH_H
#define _XTOTO_HASH_H

struct HASH;

extern struct HASH *hash_create (int lists, int (*delta)(const void*));
extern void hash_destroy (struct HASH *hast, void *data, void (*crush) (void *));
extern void hash_destroy_all (struct HASH *hash, void (*crush) (void *));
extern int hash_has (struct HASH *hash, const void *data);
extern void hash_insert (struct HASH *hash, void *data);
extern void hash_iterate (struct HASH *hash, void (*func) (void *, void *), void *misc);
extern void *hash_search (struct HASH *hash, const void *data, int (*comp) (const void *, const void *));
extern void *hash_search_all (struct HASH *hash, const void *data, int (*comp) (const void *, const void *));
extern void hash_unlink (struct HASH *hash, const void *data);
extern void hash_unlink_all (struct HASH *hash);

#endif
