/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XTOTO_AVLTREE_H
#define _XTOTO_AVLTREE_H

#define AVLTREE_PRE_ORDER  -1
#define AVLTREE_IN_ORDER    0
#define AVLTREE_POST_ORDER  1

struct AVLTREE;

extern struct AVLTREE *avltree_create (int (*comp) (const void*, const void *));
extern int avltree_destroy (struct AVLTREE *, void *, void (*crush) (void *));
extern void avltree_destroy_all (struct AVLTREE *, void (*crush) (void *));
extern void *avltree_get_maximum (struct AVLTREE *);
extern void *avltree_get_minimum (struct AVLTREE *);
extern void *avltree_get_predecessor (struct AVLTREE *, const void *data);
extern void *avltree_get_successor (struct AVLTREE *, const void *data);
extern int avltree_has (struct AVLTREE *, const void *data);
extern void avltree_insert (struct AVLTREE *, void *data);
extern void avltree_iterate (struct AVLTREE *, int order, void (*func) (void*, void *), void *misc);
extern void *avltree_search (struct AVLTREE *, const void *data);
extern void *avltree_search2 (struct AVLTREE *, const void *data, int (*) (const void *, const void *));
extern void avltree_swap (struct AVLTREE *, const void *, const void *);
extern int avltree_unlink (struct AVLTREE *, const void *data);
extern void avltree_unlink_all (struct AVLTREE *);

#endif
