/*
 * Copyright (C) 1997 Tobias Gloth (gloth@unknown.westfalen.de)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XTOTO_ARGS_H
#define _XTOTO_ARGS_H

#define ARG_HELP    0x01
#define ARG_VERSION 0x02
#define ARG_LICENSE 0x04
#define ARG_VERBOSE 0x08
#define ARG_DEBUG   0x10
#define ARG_ALL     0x1f

typedef enum {
    ARG_END,
    ARG_UNKNOWN,
    ARG_SWITCH,
    ARG_ISWITCH,
    ARG_CHOICE,
    ARG_COMMAND,
    ARG_COMMAND_ARG,
    ARG_FLOAT,
    ARG_INT,
    ARG_PINT,
    ARG_NNINT,
    ARG_STRING
} ARG_TYPE;

extern int debug;
extern int verbose;
extern int fargc;
extern char **fargv;

extern void get_args (int, char **);
extern void parse_command_line (int argc, char **argv, int flags, ...);

#endif
