/*
 *
 * $Id: udp_shandler.h,v 1.2.4.41 2000/03/16 17:13:25 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  Signal handlers.
 *
 * Server that accepts connections (requests) continuously
 * and changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __UDP_SHANDLER_H
#define __UDP_SHANDLER_H


#include <signal.h>

#include <unistd.h>
#include <stdio.h>
#include <errno.h>

#include <time.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <pthread.h>

#ifndef __CONFIG_H
#include <config.h>
#endif


/*  Signal handler to clean up on termination.  */
void term_handler __P ((int signum));

/*  Signal handler to close, then reopen log file.  */
void shup_handler __P ((int signum));


#endif /* __UDP_SHANDLER_H */


