/*
 *
 * $Id: udp_shandler.c,v 1.2.4.41 2000/03/16 17:13:24 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  Signal handlers.
 *
 * Server that accepts connections (requests) continuously
 * and changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <stdlib.h>

#ifndef __CONFIG_H
#include <config.h>
#endif

extern char log_filename[MAX_FILEPATH];  /* Filename after TMPDIR has
                                                        been resolved */

#ifndef __UDP_SHANDLER_H
#include <udp_shandler.h>
#endif

#ifndef __UDP_DAEMON_H
#include <udp_daemon.h>
#endif

#ifndef __LOGGING_H
#include <logging.h>
#endif


/* Socket to communicate with clients */
extern int udp_client_sock;

/* Array of file descriptors and addresses */
extern struct udp_respond udp_response_table[32];

/* Protect access to the udp_response_table */
extern pthread_mutex_t udp_response_mutex;

/* Socket to communicate with pvmsyncd locally */
extern int unix_server_sock;

/* File descriptor for run/log file */
volatile int log_fd;

/* Protect access to the logfile fd */
pthread_mutex_t *wrlog_mutex;


/*  Signal handler to clean up on termination.  */
void term_handler(int signum)
{
int index;

  (void) close (unix_server_sock);
  (void) close (udp_client_sock);

  (void) pthread_mutex_lock (&udp_response_mutex);

  for (index = 0; index < 32; index++) {
    if (udp_response_table[index].sock >= 0)
      (void) close (udp_response_table[index].sock);
    if (udp_response_table[index].inet_addr != NULL)
      free (udp_response_table[index].inet_addr);
  }

  (void) pthread_mutex_lock (wrlog_mutex);
         report_log ("pvmobjd: server shutting down\n");

  (void) close (log_fd);

  /* We'll exit with the mutexes still locked in case somebody
     still wants some action. */

exit(0);
}

/*  Signal handler to close, then reopen log file.  */
void shup_handler (int signum)
{
char *curr_timestr;
char log_str[128], timebuf[26];
char *reopen_mesg = "caught SIGHUP, reopening log file";
time_t time_p;
struct tm *now_time;

  if (signum != SIGHUP)
        return;

#ifdef __LOG_SYSLOG
#ifndef DEBUG
  openlog ("pvmsync", LOG_CONS | LOG_PID, LOG_USER);
#endif

  /* Make an entry in the syslog that there's nothing to do. */
  syslog (LOG_INFO, "caught SIGHUP, no logfile to reopen\n");

#ifndef DEBUG
  closelog();
#endif

#else
  (void) pthread_mutex_lock(wrlog_mutex);
  (void) time (&time_p);
  now_time = localtime (&time_p);
  curr_timestr = asctime_r (now_time, timebuf);
  curr_timestr[strlen(curr_timestr)-1] = '\0';
  snprintf(log_str, 128, "%s pvmobjd[%d]: %s\n", curr_timestr, getpid(),
                                                           reopen_mesg);
  (void) write (log_fd, log_str, strlen(log_str)); 
  (void) close (log_fd);
  log_fd = open (log_filename, (O_CREAT | O_APPEND | O_WRONLY), 0644);
  if (log_fd == -1)
                exit(1);
  now_time = localtime (&time_p);
  curr_timestr = asctime_r (now_time, timebuf);
  curr_timestr[strlen(curr_timestr)-1] = '\0';
  snprintf(log_str, 128, "%s pvmobjd[%d]: %s\n", curr_timestr,
                        getpid(), "new logfile created");
  (void) write (log_fd, log_str, strlen(log_str));
  (void) pthread_mutex_unlock(wrlog_mutex);
#endif

return;
}


