/*
 *
 * $Id: udp_daemon.h,v 1.2.4.41 2000/03/16 17:13:22 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  udp daemon decls.
 *
 * Server that accepts connections (requests) for shared
 * data or synchronization mechanisms continuously and
 * changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef __UDP_DAEMON_H
#define __UDP_DAEMON_H


#ifndef __CONFIG_H
  /* SYMBOL_LENGTH */
#include <config.h>
#endif

/* int16_t */
#include <db.h>

/* struct sockaddr_un */
#include <sys/socket.h>


/* All application-level headers start with this as the first byte */
#define UDP_MAGIC_NO              (char) 0x61

/* Protocol version */
#define PROTOCOL_VERS             (char) 0x1

/* Request/Reply field */
#define UDP_REQUEST               (char) 0x1
#define UDP_REPLY                 (char) 0x2

/* Format of data area of datagram.  Includes application-level
   header and data payload.  Entire data portion no less than 16 bytes
   long in multiples of four. */
struct udp_app_dgram {
  char magic,               /* Magic # */
       version,             /* Protocol version */
       obj_type,            /* Object Type */
       length,              /* Total length of 'data' portion */
       dgram_type,          /* Whether request or reply */
       seq_num;             /* 1 byte to distinguish current transaction */
  int16_t num_arg;          /* Optional numeric argument */
  char dp[SYMBOL_LENGTH];   /* String containing object name, null
                               terminated if less than SYMBOL_LENGTH
                               bytes long */
} __attribute__ ((packed));

/*
 * Extract out interesting parts of the udp app headers.
 */

/* Return the object type of the packet */
#define udp_objtype(packet)     (packet)->obj_type

/* Return length of packet */
#define udp_pcktlen(packet)     (packet)->length

/* Return the sequence number contained in the packet */
#define udp_seqnum(packet)      (packet)->seq_num

/* Return the optional numeric argument contained in header */
#define udp_numarg(packet)      (int16_t) (packet)->num_arg

/* Data area of packet */
#define udp_data(packet)        (char *)  (packet)->dp

/*
 * Check out the format/contents of udp app headers.
 */

/* int udp_ck_magic (struct udp_app_dgram *packet) */
/* nonzero if magic # checks out, zero if not */
#define udp_ck_magic(packet)        ((packet)->magic == UDP_MAGIC_NO)

/* int udp_ck_vers (struct udp_app_dgram *packet) */
/* nonzero if version checks out, zero if not */
#define udp_ck_vers(packet)         ((packet)->version == PROTOCOL_VERS)

/* int udp_ck_len (struct udp_app_dgram *packet) */
/* nonzero if length is OK, zero if not */
#define udp_ck_len(packet)          (udp_pcktlen(packet) >= 2)

/* int udp_ck_type (struct udp_app_dgram *packet, char type) */
/* nonzero if type matches, zero if not */
#define udp_ck_type(packet, type)   (udp_objtype(packet) == type)

/* Verify the contents of packet header */
/* nonzero if packet is OK, zero if not */
#define vrfy_udp_head(packet) \
                         (udp_ck_magic (packet) && \
                          udp_ck_vers  (packet) && \
                          udp_ck_len   (packet))

/* Verify that we have a proper udp request */
/* nonzero if packet is OK, zero if not */
#define vrfy_udp_request(packet) \
                         (udp_ck_type   (packet, UDP_REQUEST) && \
                          vrfy_udp_head (packet))

/* Verify that we have a proper udp reply */
/* nonzero if packet is OK, zero if not */
#define vrfy_udp_reply(packet) \
                         (udp_ck_type   (packet, UDP_REPLY) && \
                          vrfy_udp_head (packet))

/* We will maintain an array of these */
struct udp_respond {
  int sock;                       /* Socket to respond on */
  struct sockaddr_in *inet_addr;  /* Address for responses,
                                     filled in by recvfrom(2) */
  struct udp_app_dgram packet;    /* Packet struct for the
                                     incoming message, enough
                                     to hold 64 bit header and
                                     a full symbol name */
};


/* Print usage information and exit*/
void usage __P ((char *program_name)) __attribute__ ((noreturn));

/* Write PID to pidfile */
/* 0 on success, -1 on fail */
int wr_pidfile __P ((char *run_dir));

/* Set up struct sockaddr_un */
/* 0 on success, -1 on fail */
int setup_sockaddr_un __P ((struct sockaddr_un *unix_addr));

/* Function to process the query received by the udp daemon
   (look up with tcp server), then respond with a datagram
   if appropriate. */
void * proc_query __P ((void *index));

/* free stuff, mark our fd as invalid, and exit (pthread_exit) */
inline void cleanup __P ((void *index));


#endif /* __UDP_DAEMON_H */

