/*
 * Andrew Pitman
 *
 * $Id: waitfor.c,v 1.2.4.41 2000/03/16 17:15:16 ajp Exp $
 *
 * pvmsync, a distributed synchronization server: extra tools
 *
 * waitfor: wait for dispatch before starting command
 * given as argument.
 * (listens for a datagram at port LISTEN_PORT)
 *
 * Copyright (C) 1999 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LISTEN_PORT           1215

#define ENABLE                  0x001
#define DISABLE                 0x000

int main(int argc, char *argv[])
{
char recvbuf[32], errstring[64];
struct sockaddr_in *from;
int errstatus, bytes;

/* File descriptor for socket */
int sockfd;

  if (argc < 2) {
	fprintf(stderr, "%s: error: need argument\n", argv[0]);
	exit(1);
  }

  /* First, create the socket */
  sockfd = socket (AF_INET, SOCK_DGRAM, 0);
  if (sockfd < 0) {
	memset(errstring, 0, 64);
	snprintf(errstring, 64, "%s: socket", argv[0]);
	perror(errstring);
	exit(1);
  }

  /* Allow broadcasts on this socket */
  /*errstatus = setsockopt (sockfd, SOL_SOCKET, SO_BROADCAST,
                                (void *) ENABLE, sizeof(char));*/

  from = (struct sockaddr_in *) malloc (sizeof (struct sockaddr_in));
  if (from == NULL) {
	fprintf(stderr, "%s: malloc: couldn't allocate memory\n", argv[0]);
	exit(1);
  }
  memset(from, 0, sizeof (struct sockaddr_in));

  from->sin_family = AF_INET;
  from->sin_port = htons(LISTEN_PORT);
  from->sin_addr.s_addr = INADDR_ANY;

  /* Bind to address */
  errstatus = bind (sockfd, (struct sockaddr *) from, sizeof (struct sockaddr_in));
  if (errstatus) {
	memset(errstring, 0, 64);
	snprintf(errstring, 64, "%s: bind", argv[0]);
	perror(errstring);
	exit(1);
  }

  /* Finally, we wait for the broadcast. */
  bytes = recvfrom(sockfd, recvbuf, 32, 0,
				NULL, NULL);
  if (bytes < 0) {
	memset(errstring, 0, 64);
	snprintf(errstring, 64, "%s: recvfrom", argv[0]);
	perror(errstring);
	exit(1);
  }

  if ((bytes == strlen ("START")) && (strcmp (recvbuf, "START"))) {
	printf("%s: received start\n", argv[0]);
	if (argc == 2) {
	    errstatus = execlp (argv[1], argv[1], NULL);
	} else {
	    errstatus = execvp (argv[1], argv+1);
	}
	if (errstatus) {
	    memset(errstring, 0, 64);
	    snprintf(errstring, 64, "%s: couldn't execvp", argv[0]);
	    perror(errstring);
	    exit(1);
	}
  }

return 0;
}


