/*
 * Andrew Pitman
 *
 * $Id: dispatch.c,v 1.2.4.41 2000/03/16 17:15:14 ajp Exp $
 *
 * pvmsync, a distributed synchronization server: extra tools
 *
 * Dispatch waiting invocations of waitfor at the address given.
 * If the address given is the broadcast address, ALL instances
 * of waitfor on subnet will be dispatched.
 * (transmits a datagram at port TRANSMIT_PORT)
 *
 * Copyright (C) 1999 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* The port the clients are eagerly waiting on.... */
#define TRANSMIT_PORT          1215

#define ENABLE                  0x001
#define DISABLE                 0x000

int main(int argc, char *argv[])
{
struct sockaddr_in *to;
struct in_addr *send_address;
char *message = "START", errstring[64];
int status, enable;

/* File descriptor */
int sockfd;

  /* Barf and exit if we're missing an arg */
  if (argc != 2) {
	fprintf (stderr, "%s: need address argument\n", argv[0]);
	exit(1);
  }

  to = (struct sockaddr_in *) malloc (sizeof (struct sockaddr_in));
  if (to == NULL) {
	fprintf(stderr, "%s: malloc: couldn't allocate memory\n", argv[0]);
	exit(1);
  }
  memset (to, 0, sizeof (struct sockaddr_in));

  send_address = (struct in_addr *) malloc (sizeof (struct in_addr));
  if (send_address == NULL) {
	fprintf(stderr, "%s: malloc: couldn't allocate memory\n", argv[0]);
	exit(1);
  }
  memset (send_address, 0, sizeof (struct sockaddr_in));

  if (!(inet_aton (argv[1], send_address))) {
	fprintf(stderr, "%s: inet_aton: invalid address\n", argv[0]);
	exit(1);
  }

  to->sin_family = AF_INET;
  to->sin_port = htons(TRANSMIT_PORT);
  memcpy (&to->sin_addr, send_address, sizeof (struct in_addr));

  /* create the socket */
  sockfd = socket (AF_INET, SOCK_DGRAM, 0);
  if (sockfd < 0) {
	memset(errstring, 0, 64);
	snprintf(errstring, 64, "%s: socket", argv[0]);
	perror(errstring);
	exit(1);
  }

  /* Allow broadcasts on this socket */
  enable = ENABLE;
  status = setsockopt (sockfd, SOL_SOCKET, SO_BROADCAST,
				&enable, sizeof(int));

  /* send "START" to the address */
  status = sendto (sockfd, (void *) message, strlen (message), 0,
					to, sizeof (struct sockaddr_in));
  if (status < 0) {
	memset(errstring, 0, 64);
	snprintf(errstring, 64, "%s: sendto", argv[0]);
	perror(errstring);
	exit(1);
  }

  if (status != strlen (message)) {
	fprintf(stderr, "%s: warning: incomplete send\n", argv[0]);
	exit(1);
  }

  /* If everything's alright, we're done */
  printf ("Waiting process(es) dispatched...\n");

return 0;
}


