/*
 *
 * $Id: tcp_shandler.c,v 1.2.4.41 2000/03/16 17:13:15 ajp Exp $
 *
 * Andrew Pitman
 *
 * pvmsync, a distributed synchronization server:  Signal handlers.
 *
 * Server that accepts connections (requests) continuously
 * and changes some internal state according to the request.
 *
 * Copyright (C) 1999, 2000 Andrew J. Pitman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __TCP_SHANDLER_H
#include <tcp_shandler.h>
#endif

/* static char tcp_run_file[] */
/* (path to run/log file) */
#ifndef __CONFIG_H
#include <config.h>
#endif

extern char log_filename[MAX_FILEPATH];  /* Filename after TMPDIR has
                                                        been resolved */

extern char *ipc_path;
extern char *progname;

extern pthread_mutex_t *wrlog_mutex;

/* modified in sighandler */
volatile int log_fd;


/*  Signal handler to clean up on termination.  */
void term_handler(int signum)
{
char errstring[32], *curr_timestr;
char log_str[128], timebuf[26];
struct tm *now_time;
time_t time_p;

  if (signum != SIGTERM)
	return;

#ifdef __LOG_SYSLOG
#ifndef DEBUG
  openlog ("pvmsync", LOG_CONS | LOG_PID, LOG_USER);
#endif
  syslog (LOG_INFO, "shutting down server\n");
  closelog();
#else
  (void) pthread_mutex_lock(wrlog_mutex);
  if (unlink (ipc_path)) {
  	snprintf(errstring, 32, "%s: unlink", progname);
	(void) time (&time_p);
  	now_time = localtime (&time_p);
  	curr_timestr = asctime_r (now_time, timebuf);
  	curr_timestr[strlen(curr_timestr)-1] = '\0';
  	snprintf(log_str, 128, "%s pvmsyncd[%d]: %s\n", curr_timestr,
                        getpid(), errstring);
  	(void) write (log_fd, log_str, strlen(log_str)); 
  	(void) close (log_fd);
  exit(1);
  }
  snprintf(errstring, 32, "shutting down server");
  (void) time (&time_p);
  now_time = localtime (&time_p);
  curr_timestr = asctime_r (now_time, timebuf);
  curr_timestr[strlen(curr_timestr)-1] = '\0';
  snprintf(log_str, 128, "%s pvmsyncd[%d]: %s\n", curr_timestr,
                        getpid(), errstring);
  (void) write (log_fd, log_str, strlen(log_str)); 
  (void) close (log_fd);
#endif

exit(0);
}

/*  Signal handler to re-open run/log file.  */
void shup_handler(int signum)
{
char *curr_timestr;
char log_str[128], timebuf[26];
char *reopen_mesg = "caught SIGHUP, reopening log file";
time_t time_p;
struct tm *now_time;

  if (signum != SIGHUP)
	return;

#ifdef __LOG_SYSLOG
#ifndef DEBUG
  openlog ("pvmsync", LOG_CONS | LOG_PID, LOG_USER);
#endif

  /* Make an entry in the syslog that there's nothing to do. */
  syslog (LOG_INFO, "caught SIGHUP, no logfile to reopen\n");

#ifndef DEBUG
  closelog();
#endif

#else
  (void) pthread_mutex_lock(wrlog_mutex);
  (void) time (&time_p);
  now_time = localtime (&time_p);
  curr_timestr = asctime_r (now_time, timebuf);
  curr_timestr[strlen(curr_timestr)-1] = '\0';
  snprintf(log_str, 128, "%s pvmsyncd[%d]: %s\n", curr_timestr, getpid(), reopen_mesg);
  (void) write (log_fd, log_str, strlen(log_str)); 
  (void) close (log_fd);
  log_fd = open (log_filename, (O_CREAT | O_APPEND | O_WRONLY), 0644);
  if (log_fd == -1)
		exit(1);
  now_time = localtime (&time_p);
  curr_timestr = asctime_r (now_time, timebuf);
  curr_timestr[strlen(curr_timestr)-1] = '\0';
  snprintf(log_str, 128, "%s pvmsyncd[%d]: %s\n", curr_timestr,
                        getpid(), "new logfile created");
  (void) write (log_fd, log_str, strlen(log_str));
  (void) pthread_mutex_unlock(wrlog_mutex);
#endif

return;
}



